/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.csv;

import de.ganzer.core.csv.InvalidCsvException;
import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.io.BOMInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CsvInputStreamReader
extends BOMInputStreamReader {
    private char valueSeparator = (char)44;
    private char maskChar = (char)34;
    private boolean readEmptyLineAsEmptyValue;
    private int lastRead;
    private int currentLine = 1;
    private int currentColumn;
    private boolean skipRead;
    private boolean eol;

    public CsvInputStreamReader(InputStream in) throws IOException {
        super(in);
    }

    public CsvInputStreamReader(InputStream in, String charsetName) throws IOException {
        super(in, charsetName);
    }

    public CsvInputStreamReader(InputStream in, Charset cs) throws IOException {
        super(in, cs);
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(char valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public char getMaskChar() {
        return this.maskChar;
    }

    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    public boolean isReadEmptyLineAsEmptyValue() {
        return this.readEmptyLineAsEmptyValue;
    }

    public void setReadEmptyLineAsEmptyValue(boolean readEmptyLineAsEmptyValue) {
        this.readEmptyLineAsEmptyValue = readEmptyLineAsEmptyValue;
    }

    public List<String> readLine() throws IOException, InvalidCsvException {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        do {
            ++this.currentColumn;
            if (this.skipRead) {
                this.skipRead = false;
            } else {
                this.lastRead = this.read();
            }
            if (this.lastRead == -1) break;
            if (this.lastRead == this.maskChar) {
                this.readMaskedValue(value);
                values.add(value.toString());
                value.setLength(0);
                if (!this.eol) continue;
                this.skipAndCountLine();
                break;
            }
            if (this.lastRead == this.valueSeparator) {
                values.add("");
                continue;
            }
            if (this.isEOL(this.lastRead)) {
                this.skipAndCountLine();
                if (values.isEmpty() && !this.readEmptyLineAsEmptyValue) continue;
                values.add("");
                break;
            }
            value.append((char)this.lastRead);
            this.readUnmaskedValue(value);
            values.add(value.toString());
            value.setLength(0);
            if (!this.eol) continue;
            this.skipAndCountLine();
            break;
        } while (this.lastRead != -1);
        return values;
    }

    private void readUnmaskedValue(StringBuilder value) throws IOException {
        while (true) {
            ++this.currentColumn;
            this.lastRead = this.read();
            if (this.lastRead == -1 || this.lastRead == this.valueSeparator) break;
            if (this.isEOL(this.lastRead)) {
                this.eol = true;
                break;
            }
            value.append((char)this.lastRead);
        }
    }

    private void readMaskedValue(StringBuilder value) throws IOException {
        while (true) {
            ++this.currentColumn;
            if (this.skipRead) {
                this.skipRead = false;
            } else {
                this.lastRead = this.read();
            }
            if (this.lastRead == -1) {
                throw new InvalidCsvException(CoreMessages.get("unexpectedEndOfData", this.currentLine, this.currentColumn));
            }
            if (this.lastRead != this.maskChar) {
                if (!this.isEOL(this.lastRead)) {
                    value.append((char)this.lastRead);
                    continue;
                }
                this.countLine();
                if (this.lastRead == 10) {
                    value.append('\n');
                    continue;
                }
                if (this.lastRead != 13) continue;
                value.append('\r');
                this.lastRead = this.read();
                if (this.lastRead == 10) {
                    value.append('\n');
                    continue;
                }
                this.skipRead = true;
                continue;
            }
            this.lastRead = this.read();
            if (this.lastRead != this.maskChar) break;
            value.append(this.maskChar);
        }
        if (this.isEOL(this.lastRead)) {
            this.eol = true;
        } else if (this.lastRead != this.valueSeparator) {
            throw new InvalidCsvException(CoreMessages.get("separatorExpected", this.currentLine, this.currentColumn));
        }
    }

    private void skipAndCountLine() throws IOException {
        this.skipLine();
        this.countLine();
    }

    private void skipLine() throws IOException {
        if (this.lastRead == 10) {
            this.lastRead = this.read();
        } else if (this.lastRead == 13) {
            this.lastRead = this.read();
            if (this.lastRead == 10) {
                this.lastRead = this.read();
            }
        }
        this.skipRead = true;
    }

    private void countLine() {
        ++this.currentLine;
        this.currentColumn = 0;
        this.eol = false;
    }

    private boolean isEOL(int lastRead) {
        return lastRead == 13 || lastRead == 10;
    }
}

