/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.files;

import de.ganzer.core.files.DeleteErrorAction;
import de.ganzer.core.files.DeleteProgressContinuation;
import de.ganzer.core.files.DeleteProgressStatus;
import de.ganzer.core.files.FileError;
import de.ganzer.core.files.FileErrorProvider;
import de.ganzer.core.internals.CoreMessages;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FileDelete
extends FileErrorProvider {
    private final ProgressFunction progressFunction;
    private final QueryErrorAction queryErrorAction;
    private final ProgressInfo progress = new ProgressInfo(this);
    private FilenameFilter filenameFilter;

    public FileDelete(ProgressFunction progressFunction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = null;
    }

    public FileDelete(ProgressFunction progressFunction, QueryErrorAction queryErrorAction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = queryErrorAction;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public boolean start(String source, boolean suppressInit) {
        return this.start(Collections.singletonList(source), suppressInit);
    }

    public boolean start(List<String> sources, boolean suppressInit) {
        Objects.requireNonNull(sources, "sources");
        List<File> sourceFiles = sources.stream().map(File::new).collect(Collectors.toList());
        this.clearError();
        try {
            this.verifyExistence(sourceFiles);
            this.initializeDelete(sourceFiles, suppressInit);
            this.deleteEntries(sourceFiles);
        }
        catch (ErrorInfo info) {
            this.setErrorInfo(info.getError(), info.getErrorDescription());
        }
        this.reportFinished();
        return this.getError() != FileError.NONE;
    }

    private void verifyExistence(List<File> sourceFiles) throws ErrorInfo {
        sourceFiles.forEach(this::verifySourceExistence);
    }

    private void verifySourceExistence(File sourceFile) throws ErrorInfo {
        if (!sourceFile.exists()) {
            throw new ErrorInfo(FileError.FILE_NOT_EXIST, String.format(CoreMessages.get("fileDoesNotExist"), sourceFile.getAbsolutePath()), true);
        }
    }

    private void initializeDelete(List<File> sourceFiles, boolean suppressInit) throws ErrorInfo {
        this.progress.status = DeleteProgressStatus.INITIALIZING;
        this.progress.entriesAvail = 0L;
        this.progress.entriesDeleted = 0L;
        this.progress.path = "";
        if (suppressInit) {
            return;
        }
        this.reportProgress();
        sourceFiles.forEach(source -> {
            this.progress.rootPath = source.getAbsolutePath();
            if (source.isDirectory()) {
                this.initializeDelete((File)source);
            } else {
                this.reportInitializeProgress(source.getAbsolutePath());
            }
        });
    }

    private void initializeDelete(File source) {
        this.reportInitializeProgress(source.getAbsolutePath());
        for (File file : this.listFiles(source)) {
            if (this.isDirectory(file)) {
                this.initializeDelete(file);
                continue;
            }
            this.reportInitializeProgress(file.getAbsolutePath());
        }
    }

    private void deleteEntries(List<File> sourceFiles) throws ErrorInfo {
        sourceFiles.forEach(source -> {
            this.progress.rootPath = source.getAbsolutePath();
            if (this.isDirectory((File)source)) {
                this.deleteDir((File)source);
            } else {
                this.deleteFile((File)source);
            }
        });
    }

    private void deleteFile(File source) {
        this.reportDelete(source, DeleteProgressStatus.DELETE_FILE);
        block6: while (true) {
            try {
                this.deleteFileNoQuery(source);
            }
            catch (ErrorInfo info) {
                if (this.queryErrorAction == null || info.doNotQuery()) {
                    throw info;
                }
                switch (this.queryErrorAction.query(info.getError(), info.getErrorDescription(), source)) {
                    case RETRY: {
                        continue block6;
                    }
                    case IGNORE: {
                        return;
                    }
                }
                throw new ErrorInfo(info.getError(), info.getErrorDescription(), false);
            }
            break;
        }
    }

    private void deleteFileNoQuery(File source) {
        try {
            if (!source.delete()) {
                throw new ErrorInfo(FileError.DELETE_DIR, String.format(CoreMessages.get("cannotDeleteFile"), source.getAbsolutePath()), true);
            }
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), source.getAbsolutePath()), true);
        }
    }

    private void deleteDir(File source) {
        block6: while (true) {
            try {
                this.deleteDirNoQuery(source);
            }
            catch (ErrorInfo info) {
                if (this.queryErrorAction == null || info.doNotQuery()) {
                    throw info;
                }
                switch (this.queryErrorAction.query(info.getError(), info.getErrorDescription(), source)) {
                    case RETRY: {
                        continue block6;
                    }
                    case IGNORE: {
                        return;
                    }
                }
                throw new ErrorInfo(info.getError(), info.getErrorDescription(), false);
            }
            break;
        }
    }

    private void deleteDirNoQuery(File source) {
        for (File file : this.listFiles(source)) {
            if (this.isDirectory(file)) {
                this.deleteDir(file);
                continue;
            }
            this.deleteFile(file);
        }
        this.reportDelete(source, DeleteProgressStatus.DELETE_DIRECTORY);
        try {
            if (!source.delete()) {
                throw new ErrorInfo(FileError.DELETE_DIR, String.format(CoreMessages.get("cannotDeleteDir"), source.getAbsolutePath()), true);
            }
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), source.getAbsolutePath()), true);
        }
    }

    private boolean isDirectory(File file) throws ErrorInfo {
        try {
            return file.isDirectory();
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), file.getAbsolutePath()), true);
        }
    }

    private File[] listFiles(File source) {
        try {
            return this.filenameFilter == null ? source.listFiles() : source.listFiles(this.filenameFilter);
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), source.getAbsolutePath()), true);
        }
    }

    private void reportProgress() {
        if (this.progressFunction == null) {
            return;
        }
        DeleteProgressContinuation result = this.progressFunction.report(this.progress);
        if (result == DeleteProgressContinuation.CANCEL) {
            this.cancel();
        }
    }

    private void reportInitializeProgress(String sourcePath) {
        this.progress.path = sourcePath;
        ++this.progress.entriesAvail;
        this.reportProgress();
    }

    private void reportDelete(File source, DeleteProgressStatus status) {
        this.progress.status = status;
        this.progress.path = source.getAbsolutePath();
        ++this.progress.entriesDeleted;
        this.reportProgress();
    }

    private void reportFinished() {
        this.progress.status = DeleteProgressStatus.FINISHED;
        this.progress.path = "";
        this.progress.rootPath = "";
        this.reportProgress();
    }

    private void cancel() throws ErrorInfo {
        throw new ErrorInfo(FileError.CANCELED, CoreMessages.get("operationCanceled"), false);
    }

    public static class ProgressInfo {
        private final FileDelete machine;
        private DeleteProgressStatus status;
        private String path;
        private String rootPath;
        private long entriesAvail;
        private long entriesDeleted;

        private ProgressInfo(FileDelete machine) {
            this.machine = machine;
        }

        public FileDelete getMachine() {
            return this.machine;
        }

        public DeleteProgressStatus getStatus() {
            return this.status;
        }

        public String getPath() {
            return this.path;
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public long getEntriesAvail() {
            return this.entriesAvail;
        }

        public long getEntriesDeleted() {
            return this.entriesDeleted;
        }

        public double getPercentage() {
            return (double)this.entriesDeleted * 100.0 / (double)this.entriesAvail;
        }
    }

    public static interface ProgressFunction {
        public DeleteProgressContinuation report(ProgressInfo var1);
    }

    public static interface QueryErrorAction {
        public DeleteErrorAction query(FileError var1, String var2, File var3);
    }

    private static class ErrorInfo
    extends RuntimeException {
        private final boolean queryHandling;
        private final FileError error;

        public ErrorInfo(FileError error, String errorDescription, boolean queryHandling) {
            super(errorDescription);
            this.queryHandling = queryHandling;
            this.error = error;
        }

        public boolean doNotQuery() {
            return !this.queryHandling;
        }

        public FileError getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.getMessage();
        }
    }
}

