/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class UniformFloatingPointDistribution
implements Distribution<Double> {
    private final double min;
    private final double max;

    public UniformFloatingPointDistribution() {
        this(0.0, 1.0);
    }

    public UniformFloatingPointDistribution(double max) {
        this(0.0, max);
    }

    public UniformFloatingPointDistribution(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min,max");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public Double next(Random random) {
        return random.nextDouble() * (this.max - this.min) + this.min;
    }
}

