/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.Validator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;
import java.util.List;

public class ListValidator
extends Validator {
    private List<String> validInputs;
    private boolean ignoreCase;

    public ListValidator() {
    }

    public ListValidator(int options) {
        super(options);
    }

    public ListValidator(List<String> validInputs) {
        this.validInputs = validInputs;
    }

    public ListValidator(int options, List<String> validInputs) {
        super(options);
        this.validInputs = validInputs;
    }

    public ListValidator(List<String> validInputs, boolean ignoreCase) {
        this.validInputs = validInputs;
        this.ignoreCase = ignoreCase;
    }

    public ListValidator(int options, List<String> validInputs, boolean ignoreCase) {
        super(options);
        this.validInputs = validInputs;
        this.ignoreCase = ignoreCase;
    }

    public List<String> getValidInputs() {
        return this.validInputs;
    }

    public void setValidInputs(List<String> validInputs) {
        this.validInputs = validInputs;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        if (!super.doInputValidation(text, autoFill)) {
            return false;
        }
        if (this.validInputs == null || this.validInputs.isEmpty() || text.isEmpty()) {
            return true;
        }
        String input = text.toString();
        if (this.ignoreCase) {
            for (String validInput : this.validInputs) {
                if (!validInput.toLowerCase().startsWith(input.toLowerCase())) continue;
                return true;
            }
        } else {
            for (String validInput : this.validInputs) {
                if (!validInput.startsWith(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (this.validInputs == null || this.validInputs.isEmpty() || text.isEmpty()) {
            return true;
        }
        boolean result = this.ignoreCase ? this.validInputs.stream().anyMatch(s -> s.equalsIgnoreCase(text)) : this.validInputs.contains(text);
        if (!result) {
            er.setException(new ValidatorException(this.getErrorMessage() == null ? CoreMessages.get("inputDoesNotMatchList") : this.getErrorMessage()));
        }
        return result;
    }
}

