/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.CharCountValidator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpressionValidator
extends CharCountValidator {
    private Pattern pattern;

    public RegularExpressionValidator() {
    }

    public RegularExpressionValidator(int options) {
        super(options);
    }

    public RegularExpressionValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegularExpressionValidator(int options, Pattern pattern) {
        super(options);
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        if (!super.doInputValidation(text, autoFill)) {
            return false;
        }
        if (text.length() == 0) {
            return true;
        }
        int end = RegularExpressionValidator.firstFailurePoint(this.pattern, text.toString());
        return end == -1 || end == text.length();
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (text.isEmpty() || this.pattern == null) {
            return true;
        }
        if (this.pattern.matcher(text).matches()) {
            return true;
        }
        er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : String.format(CoreMessages.get("inputDoesNotMatchExpression"), this.getPattern())));
        return false;
    }

    private static int firstFailurePoint(Pattern pattern, String text) {
        for (int i = 1; i <= text.length(); ++i) {
            Matcher m = pattern.matcher(text.substring(0, i));
            if (m.matches() || m.hitEnd()) continue;
            return i - 1;
        }
        return pattern.matcher(text).matches() ? -1 : text.length();
    }
}

