/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.TextFormat;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;
import java.util.Objects;

public class Validator {
    private int options;
    private String errorMessage;
    private Object tag;

    public Validator() {
        this.options = 1;
    }

    public Validator(int options) {
        this.options = options;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int validatorOptions) {
        this.options = validatorOptions;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage == null || errorMessage.isBlank() || errorMessage.isEmpty() ? null : errorMessage;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public boolean hasOption(int validatorOption) {
        return (this.options & validatorOption) != 0;
    }

    public final boolean isValidInput(StringBuilder text, boolean autoFill) {
        Objects.requireNonNull(text, "text");
        return this.doInputValidation(text, autoFill && this.hasOption(4));
    }

    public final void validate(String input) throws ValidatorException {
        ValidatorExceptionRef er = new ValidatorExceptionRef();
        if (!this.validate(input, er)) {
            throw er.getException();
        }
    }

    public final boolean validate(String input, ValidatorExceptionRef er) {
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(er, "er");
        return this.doValidate(input, er);
    }

    public final String formatText(String input, TextFormat how) {
        Objects.requireNonNull(input, "input");
        return this.doFormatText(input, how);
    }

    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        return true;
    }

    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        er.setException(null);
        if (text.isEmpty()) {
            if (this.hasOption(1)) {
                er.setException(new ValidatorException(this.errorMessage != null ? this.errorMessage : CoreMessages.get("inputRequired")));
            }
        } else if (text.trim().isEmpty() && !this.hasOption(2)) {
            er.setException(new ValidatorException(this.errorMessage != null ? this.errorMessage : CoreMessages.get("blanksNotAllowed")));
        }
        return er.getException() == null;
    }

    protected String doFormatText(String text, TextFormat how) {
        return text;
    }
}

