/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.install;

import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.install.LauncherInstaller;
import de.velocom.veloport.core.install.LauncherInstallerException;
import de.velocom.veloport.core.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class WindowsLauncherInstaller
implements LauncherInstaller {
    private final Path jarPath;
    private final Path javaPath;

    public WindowsLauncherInstaller() {
        this.jarPath = null;
        this.javaPath = null;
    }

    public WindowsLauncherInstaller(Path jarPath, Path javaPath) {
        this.jarPath = jarPath;
        this.javaPath = javaPath;
    }

    @Override
    public void installLauncher(String launcherName, Path manifestPath, boolean force) throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createWindowsIcon(false);
            this.createWindowsIcon(true);
            this.createLauncher(true, false, launcherName, manifestPath);
            this.createLauncher(false, false, launcherName, manifestPath);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void installConfigLauncher() throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createLauncher(false, true, null, null);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeLauncher(String launcherName) throws LauncherInstallerException {
        try {
            Files.deleteIfExists(Path.of(this.getDesktopDir(), launcherName + ".lnk"));
            Files.deleteIfExists(Path.of(System.getProperty("user.home"), "AppData", "Roaming", "Microsoft", "Windows", "Start Menu", "Programs", launcherName + ".lnk"));
        }
        catch (IOException e) {
            throw new LauncherInstallerException(Messages.get("error.removeLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeConfigLauncher() throws LauncherInstallerException {
        try {
            Files.deleteIfExists(Path.of(System.getProperty("user.home"), "AppData", "Roaming", "Microsoft", "Windows", "Start Menu", "Programs", Messages.get("velo.port.launcher.config") + ".lnk"));
        }
        catch (IOException e) {
            throw new LauncherInstallerException(Messages.get("error.removeLauncher", e.getLocalizedMessage()), e);
        }
    }

    private void createLauncher(boolean desktop, boolean config, String launcherName, Path manifestPath) throws IOException {
        String name = config ? Messages.get("velo.port.launcher.config") : launcherName;
        String targetDir = desktop ? this.getDesktopDir() : Path.of(System.getProperty("user.home"), "AppData", "Roaming", "Microsoft", "Windows", "Start Menu", "Programs").toString();
        this.createLauncher(targetDir, name, config, manifestPath);
    }

    private String getDesktopDir() {
        PointerByReference ref = new PointerByReference();
        WinNT.HRESULT res = Shell32.INSTANCE.SHGetKnownFolderPath(KnownFolders.FOLDERID_Desktop, 0, null, ref);
        if (!WinError.S_OK.equals(res)) {
            Logger.log(1, Messages.get("log.errorWindowsAPICall", res));
            return Path.of(System.getProperty("user.home"), "Desktop").toString();
        }
        String dir = ref.getValue().getWideString(0L);
        Ole32.INSTANCE.CoTaskMemFree(ref.getValue());
        return dir;
    }

    private void createLauncher(String targetDir, String name, boolean config, Path manifestPath) throws IOException {
        assert (this.jarPath != null);
        String manPath = manifestPath != null ? String.format("\\\"%s\\\"", manifestPath) : "";
        String psCommand = "$WshShell = New-Object -ComObject WScript.Shell;\n$Shortcut = $WshShell.CreateShortcut('%s');\n$Shortcut.TargetPath = '%s';\n$Shortcut.Arguments = '-jar \\\"%s\\\" %s';\n$Shortcut.IconLocation = '%s';\n$Shortcut.WorkingDirectory = '%s';\n$Shortcut.Save()\n".formatted(Path.of(targetDir, name + ".lnk"), this.javaPath, this.jarPath, config ? "--configure" : manPath, Path.of(this.jarPath.getParent().toString(), config ? "config-icon.ico" : "icon.ico"), this.jarPath.getParent());
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-Command", psCommand);
        Process process = pb.start();
        String errorOutput = new String(process.getErrorStream().readAllBytes(), StandardCharsets.ISO_8859_1);
        if (!errorOutput.isBlank()) {
            Logger.log(1, errorOutput);
        }
        int exit = 0;
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Powershell exit code: " + exit);
    }

    private void createWindowsIcon(boolean config) throws IOException {
        assert (this.jarPath != null);
        Logger.log(3, Messages.get("log.createIcon"));
        String iconName = config ? "config-icon.ico" : "icon.ico";
        Path iconPath = Path.of(this.jarPath.getParent().toString(), iconName);
        String resName = config ? "/de/velocom/veloport/core/icons/vp_config_icon.ico" : "/de/velocom/veloport/core/icons/vp_icon.ico";
        try (InputStream in = this.getClass().getResourceAsStream(resName);){
            if (in == null) {
                throw new IOException("Resource \"" + resName + "\" not found in JAR");
            }
            Files.copy(in, iconPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

