/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.util;

import de.ganzer.core.csv.CsvInputStreamReader;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.util.ManifestException;
import de.velocom.veloport.core.util.ManifestInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;

public final class Manifests {
    public static final String SRC_URL_PREFIX = "#src-url=";
    public static final String JRE_PREFIX = "#jre=";
    public static final String VP_NAME_PREFIX = "#vp-name=";
    public static final String VP_DIR_PREFIX = "#vp-dir=";

    public static ManifestInfo getManifestInfo(Path path) throws ManifestException {
        try {
            String jre = null;
            String vpDir = null;
            String vpName = null;
            String srcURL = null;
            try (FileInputStream in = new FileInputStream(path.toFile());
                 CsvInputStreamReader reader = new CsvInputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                while (reader.ready()) {
                    List<String> line = reader.readLine();
                    if (line.isEmpty()) continue;
                    if (line.getFirst().startsWith(JRE_PREFIX)) {
                        jre = line.getFirst().substring(JRE_PREFIX.length()).trim();
                        continue;
                    }
                    if (line.getFirst().startsWith(SRC_URL_PREFIX)) {
                        srcURL = line.getFirst().substring(SRC_URL_PREFIX.length()).trim();
                        continue;
                    }
                    if (line.getFirst().startsWith(VP_NAME_PREFIX)) {
                        vpName = line.getFirst().substring(VP_NAME_PREFIX.length()).trim();
                        continue;
                    }
                    if (!line.getFirst().startsWith(VP_DIR_PREFIX)) continue;
                    vpDir = line.getFirst().substring(VP_DIR_PREFIX.length()).trim();
                }
            }
            return new ManifestInfo(srcURL, jre, vpName, vpDir);
        }
        catch (IllegalArgumentException e) {
            throw new ManifestException(Messages.get("error.corruptedInstallation", Messages.get("error.noJreVersion", path)), e);
        }
        catch (FileNotFoundException e) {
            throw new ManifestException(Messages.get("error.corruptedInstallation", Messages.get("error.noManifest", path)), e);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ManifestException(Messages.get("error.corruptedInstallation", Messages.get("error.invalidURL", path)), e);
        }
        catch (IOException e) {
            throw new ManifestException(Messages.get("error.corruptedInstallation", Messages.get("error.readManifest", path)), e);
        }
    }
}

