/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.installer;

import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import de.ganzer.core.OS;
import de.ganzer.core.files.DeleteErrorAction;
import de.ganzer.core.files.DeleteProgressContinuation;
import de.ganzer.core.files.FileDelete;
import de.ganzer.core.files.FileError;
import de.velocom.veloport.core.Settings;
import de.velocom.veloport.core.SingleInstanceManager;
import de.velocom.veloport.core.download.FSDownloader;
import de.velocom.veloport.core.download.HTTPSDownloader;
import de.velocom.veloport.core.gui.LogUI;
import de.velocom.veloport.core.install.AbstractVPInstaller;
import de.velocom.veloport.core.install.JREInstaller;
import de.velocom.veloport.core.install.LauncherInstaller;
import de.velocom.veloport.core.install.LauncherInstallerException;
import de.velocom.veloport.core.install.LinuxLauncherInstaller;
import de.velocom.veloport.core.install.MacLauncherInstaller;
import de.velocom.veloport.core.install.StarterInstaller;
import de.velocom.veloport.core.install.WindowsLauncherInstaller;
import de.velocom.veloport.core.logging.ConsoleLogTarget;
import de.velocom.veloport.core.logging.Logger;
import de.velocom.veloport.core.util.AppIcons;
import de.velocom.veloport.installer.i18n.Messages;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class Installer {
    public static final String APP_VERSION = "1.0.0";
    public static final String APP_NAME = "velo.port Installer";
    private static final String UNINSTALL_ARG = "--uninstall";
    private static final String AUTO_START_ARG = "--auto-start";
    private static final String FILE_SOURCE_ARG = "--fs-source=";
    private static final String HTTP_SOURCE_ARG = "--http-source=";
    private static final String LOG_LEVEL_ARG = "--log-level=";

    public static void main(String[] args) {
        String launcherName;
        System.out.println(Messages.get("about.versionInfo", APP_NAME, APP_VERSION));
        if (OS.isMac()) {
            List<Image> appIcons = AppIcons.getApplicationIcons(AppIcons.Type.INSTALLER);
            Taskbar.getTaskbar().setIconImage(appIcons.getLast());
            FlatMacLightLaf.setup();
        } else {
            FlatIntelliJLaf.setup();
        }
        boolean uninstall = false;
        boolean autoStart = false;
        String targetDir = Path.of(System.getProperty("user.home"), ".cache/velo.port/app/starter").toString();
        int logLevel = 3;
        AbstractVPInstaller starterInstaller = null;
        LogUI ui = new LogUI(2, Messages.get("ui.log.title"), true);
        ui.setCloseEnabled(false);
        ui.setCloseButtonText(Messages.get("ui.log.cancelInstallation"));
        for (String arg : args) {
            if (arg.equals(AUTO_START_ARG)) {
                autoStart = true;
                continue;
            }
            if (arg.equals(UNINSTALL_ARG)) {
                uninstall = true;
                continue;
            }
            if (arg.startsWith(FILE_SOURCE_ARG)) {
                starterInstaller = new StarterInstaller(new FSDownloader(Path.of(arg.substring(FILE_SOURCE_ARG.length()), "vp-starter")), targetDir, ui);
                continue;
            }
            if (arg.startsWith(HTTP_SOURCE_ARG)) {
                starterInstaller = new StarterInstaller(new HTTPSDownloader(arg.substring(HTTP_SOURCE_ARG.length()) + "/vp-starter"), targetDir, ui);
                continue;
            }
            if (arg.startsWith(LOG_LEVEL_ARG)) {
                try {
                    logLevel = Integer.parseUnsignedInt(arg.substring(LOG_LEVEL_ARG.length()));
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace(System.err);
                }
                continue;
            }
            System.err.println(Messages.get("error.unknownArgument", arg));
            System.exit(1);
        }
        Logger.addTarget(new ConsoleLogTarget(logLevel));
        ui.setVisible(true);
        if (starterInstaller == null) {
            starterInstaller = new StarterInstaller(new HTTPSDownloader("https://www.velo-port.de/start/25/vp-starter"), targetDir, ui);
        }
        String string = launcherName = starterInstaller.getLauncherName() != null ? starterInstaller.getLauncherName() : Messages.get("velo.port.launcher.name");
        if (uninstall || Installer.checkUninstall(targetDir, ui)) {
            Installer.uninstall(launcherName, ui);
            ui.setCloseEnabled(true);
            ui.close();
        }
        Installer.hideCacheDir();
        try {
            Installer.removePrevInstallation(targetDir, launcherName, ui);
            ui.setCloseEnabled(true);
            starterInstaller.start();
        }
        catch (Exception e3) {
            Logger.log(1, e3.getLocalizedMessage());
            e3.printStackTrace(System.err);
        }
        ui.setCloseEnabled(false);
        if (starterInstaller.getJREVersion() != null) {
            Path starterJarPath = Path.of(targetDir, "vp-starter.jar");
            Path javaPath = JREInstaller.getJavaExecutablePath(starterInstaller.getJREVersion());
            try {
                launcherName = starterInstaller.getLauncherName() != null ? starterInstaller.getLauncherName() : Messages.get("velo.port.launcher.name");
                Installer.installLaunchers(starterJarPath, javaPath, launcherName);
            }
            catch (Exception e4) {
                Logger.log(1, e4.getLocalizedMessage());
                e4.printStackTrace(System.err);
            }
            if (Files.exists(starterJarPath, new LinkOption[0]) && Files.exists(javaPath, new LinkOption[0])) {
                try {
                    if (Installer.shouldStart(autoStart, ui)) {
                        ProcessBuilder pb = new ProcessBuilder(javaPath.toString(), "-jar", starterJarPath.toString());
                        pb.directory(starterJarPath.getParent().toFile());
                        pb.start();
                    }
                    System.exit(0);
                }
                catch (Exception e5) {
                    Logger.log(1, e5.getLocalizedMessage());
                    e5.printStackTrace(System.err);
                }
            }
        }
        Logger.log(2, Messages.get("log.finished"));
        ui.setCloseButtonText(de.velocom.veloport.core.i18n.Messages.get("ui.log.button.close"));
        ui.addActionListener(e -> ui.close());
        ui.setCloseEnabled(true);
    }

    private static boolean checkUninstall(String targetDir, LogUI ui) {
        if (!Files.exists(Path.of(targetDir, "velo.port.starter.manifest"), new LinkOption[0])) {
            return false;
        }
        Object[] buttons = new String[]{Messages.get("ui.message.button.uninstall"), Messages.get("ui.message.button.repair"), Messages.get("ui.message.button.cancel")};
        int res = JOptionPane.showOptionDialog(ui, Messages.get("query.uninstall"), APP_NAME, -1, 1, null, buttons, buttons[1]);
        if (res == 0) {
            return true;
        }
        if (res == 1) {
            return false;
        }
        System.exit(0);
        return false;
    }

    private static boolean shouldStart(boolean autostart, Window ui) {
        if (autostart) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(ui, Messages.get("ui.finishedQuery"), APP_NAME, 0);
        return result == 0;
    }

    private static void hideCacheDir() {
        if (!OS.isWindows()) {
            return;
        }
        Path path = Path.of(System.getProperty("user.home"), ".cache");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void uninstall(String launcherName, LogUI ui) {
        if (Installer.instancesRunning(ui)) {
            return;
        }
        String targetDir = Path.of(System.getProperty("user.home"), ".cache/velo.port").toString();
        Installer.removeInstallation(targetDir, Messages.get("log.deleteVPInst"), launcherName, ui);
        Installer.removeUserSettings(ui);
    }

    private static void removeUserSettings(LogUI ui) {
        Object[] buttons = new String[]{Messages.get("ui.message.button.removeSettings"), Messages.get("ui.message.button.keepSettings")};
        int res = JOptionPane.showOptionDialog(ui, Messages.get("query.removeSettings"), APP_NAME, -1, 1, null, buttons, buttons[0]);
        if (res != 0) {
            return;
        }
        Logger.log(3, Messages.get("log.deleteSettings"));
        Path[] settingPaths = new Path[]{Installer.getLocalSettingsPath().resolve("velo.port"), Installer.getLocalSettingsPath().resolve("velo.port-starter")};
        ArrayList<String> dirs = new ArrayList<String>();
        for (Path path : settingPaths) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            dirs.add(path.toString());
        }
        if (dirs.isEmpty()) {
            return;
        }
        FileDelete del = new FileDelete(p -> DeleteProgressContinuation.CONTINUE, (e, d, f) -> {
            if (e != FileError.FILE_NOT_EXIST) {
                JOptionPane.showMessageDialog(ui, Messages.get("error.deleteSettingsError", d, settingPaths[0], settingPaths[1]), APP_NAME, 0);
            }
            return DeleteErrorAction.IGNORE;
        });
        del.start(dirs, true);
    }

    private static Path getLocalSettingsPath() {
        if (OS.isWindows()) {
            return Path.of(System.getProperty("user.home"), "AppData", "Roaming");
        }
        return Path.of(System.getProperty("user.home"), ".config");
    }

    private static boolean instancesRunning(LogUI ui) {
        SingleInstanceManager mngr = new SingleInstanceManager(Settings.user.read("starter.port", 43917));
        if (mngr.vpAlreadyStarted()) {
            JOptionPane.showMessageDialog(ui, Messages.get("error.mustCloseAllRunningVP"), APP_NAME, 0);
            return true;
        }
        return false;
    }

    private static void removePrevInstallation(String targetDir, String launcherName, LogUI ui) throws LauncherInstallerException {
        if (!Files.exists(Path.of(targetDir, "velo.port.starter.manifest"), new LinkOption[0])) {
            return;
        }
        Installer.removeInstallation(targetDir, Messages.get("log.deletePrevStarter"), launcherName, ui);
    }

    private static void removeInstallation(String targetDir, String logMessage, String launcherName, LogUI ui) {
        if (!Files.exists(Path.of(targetDir, new String[0]), new LinkOption[0])) {
            return;
        }
        Logger.log(2, logMessage);
        Installer.removeLaunchers(launcherName);
        FileDelete del = new FileDelete(p -> {
            Logger.log(3, Messages.get("log.deleteFile"), p.getPath());
            return DeleteProgressContinuation.CONTINUE;
        }, (e, d, f) -> {
            JOptionPane.showMessageDialog(ui, Messages.get("error.deletePrevInstError", f.getAbsolutePath()), APP_NAME, 0);
            return DeleteErrorAction.ABORT;
        });
        del.start(targetDir, true);
    }

    private static void installLaunchers(Path starterJarPath, Path javaPath, String starterName) throws LauncherInstallerException {
        Logger.log(2, Messages.get("log.creatingLaunchers"));
        LauncherInstaller installer = Installer.creteLauncher(starterJarPath, javaPath);
        installer.installLauncher(starterName, null, true);
        installer.installConfigLauncher();
    }

    private static void removeLaunchers(String starterName) throws LauncherInstallerException {
        LauncherInstaller installer = Installer.creteLauncher(null, null);
        installer.removeLauncher(starterName);
        installer.removeConfigLauncher();
    }

    private static LauncherInstaller creteLauncher(Path starterJarPath, Path javaPath) {
        if (OS.isWindows()) {
            return new WindowsLauncherInstaller(starterJarPath, javaPath);
        }
        if (OS.isMac()) {
            return new MacLauncherInstaller(starterJarPath, javaPath);
        }
        return new LinuxLauncherInstaller(starterJarPath, javaPath);
    }
}

