/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.download;

import de.ganzer.core.util.Strings;
import de.velocom.veloport.core.download.DownloadException;
import de.velocom.veloport.core.download.Downloader;
import de.velocom.veloport.core.i18n.Messages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FSDownloader
implements Downloader {
    private final Path srcRoot;

    public FSDownloader(Path srcRoot) {
        this.srcRoot = srcRoot;
    }

    @Override
    public boolean checkExistence(String fileName) {
        return Files.exists(this.srcRoot.resolve(fileName), new LinkOption[0]);
    }

    @Override
    public void download(String src, Path dst) throws DownloadException {
        if (Strings.isNullOrBlank((String)src)) {
            throw new IllegalArgumentException("src must not be null or blank.");
        }
        if (Strings.isNullOrBlank((String)dst.toString())) {
            throw new IllegalArgumentException("dst must not be null or blank.");
        }
        try {
            Files.createDirectories(dst.getParent(), new FileAttribute[0]);
            Files.copy(this.srcRoot.resolve(src), dst, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new DownloadException(Messages.get("error.downloadingFile", e.getLocalizedMessage()), e);
        }
    }
}

