/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.download;

import de.ganzer.core.OS;
import de.ganzer.core.util.FileNames;
import de.velocom.veloport.core.download.JREDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class HTTPSTemurinDownloader
implements JREDownloader {
    private static final String URL_FORMAT = "https://api.adoptium.net/v3/binary/latest/%s/ga/%s/%s/jre/hotspot/normal/eclipse";

    @Override
    public File download(String jreVersion) throws IOException, URISyntaxException {
        String url = String.format(URL_FORMAT, jreVersion, HTTPSTemurinDownloader.getOS(), HTTPSTemurinDownloader.getArch());
        String orgName = this.geOriginalFileName(url);
        File target = File.createTempFile("jre-", "." + FileNames.getAllExtensions((String)orgName));
        HTTPSTemurinDownloader.downloadFile(url, target.toPath());
        return target;
    }

    private String geOriginalFileName(String url) throws URISyntaxException, IOException {
        HttpURLConnection con = (HttpURLConnection)new URI(url).toURL().openConnection();
        con.setInstanceFollowRedirects(true);
        con.connect();
        String disposition = con.getHeaderField("Content-Disposition");
        String filename = null;
        if (disposition != null && disposition.contains("filename=")) {
            filename = disposition.substring(disposition.indexOf("filename=") + 9).replace("\"", "");
        }
        if (filename == null) {
            filename = Paths.get(new URI(con.getURL().toString()).getPath(), new String[0]).getFileName().toString();
        }
        return filename;
    }

    private static void downloadFile(String url, Path target) throws IOException, URISyntaxException {
        try (InputStream in = new URI(url).toURL().openStream();){
            Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static String getOS() {
        return switch (OS.getType()) {
            case OS.Type.WINDOWS -> "windows";
            case OS.Type.MAC -> "mac";
            case OS.Type.SOLARIS -> "solaris";
            default -> "linux";
        };
    }

    private static String getArch() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("aarch64")) {
            return "aarch64";
        }
        if (arch.contains("64")) {
            return "x64";
        }
        return arch;
    }
}

