/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.install;

import de.ganzer.core.csv.CsvInputStreamReader;
import de.ganzer.core.util.FileNames;
import de.ganzer.core.util.Strings;
import de.velocom.veloport.core.download.Downloader;
import de.velocom.veloport.core.gui.LogUI;
import de.velocom.veloport.core.gui.LogUICloseListener;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.install.JREInstaller;
import de.velocom.veloport.core.logging.Logger;
import de.velocom.veloport.core.util.Security;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractVPInstaller {
    private static final String DOWNLOADED_EXTENSION = ".vpd";
    private static final String RENAMED_ORG_EXTENSION = ".vpo";
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final Downloader downloader;
    private final String targetDir;
    private final LogUI logUI;
    private String orgJREVersion;
    private String newJREVersion;
    private String orgVPName;
    private String newVPName;
    private boolean updated;

    protected AbstractVPInstaller(Downloader downloader, String targetDir, LogUI logUI) {
        Objects.requireNonNull(downloader, "downloader must not be null.");
        if (Strings.isNullOrBlank((String)targetDir)) {
            throw new IllegalArgumentException("targetDir must not be null or blank.");
        }
        this.downloader = downloader;
        this.targetDir = targetDir;
        this.logUI = logUI;
    }

    public boolean checkExistence(String fileName) {
        return this.downloader.checkExistence(fileName);
    }

    public boolean start() throws Exception {
        this.canceled.set(false);
        LogUICloseListener closeListener = this.logUI != null ? new LogUICloseListener(this.logUI.getTitle(), () -> this.canceled.set(true)) : null;
        Path targetPath = Path.of(this.targetDir, new String[0]);
        try {
            List<FileInfo> files = this.downloadManifest();
            if (this.logUI != null) {
                this.logUI.addActionListener(closeListener);
            }
            Differences diff = this.getDiff(files);
            if (diff.updates.isEmpty() && diff.deletes.isEmpty()) {
                this.deleteFiles(targetPath, DOWNLOADED_EXTENSION);
                boolean bl = this.updated;
                return bl;
            }
            Logger.log(3, Messages.get("log.installInto", targetPath));
            Logger.log(2, Messages.get("log.updatingVP"));
            for (FileInfo file : diff.getUpdates()) {
                Path path = Path.of(this.targetDir, file.srcPath + DOWNLOADED_EXTENSION);
                Logger.log(2, Messages.get("log.installingFile", file.srcPath));
                this.downloader.download(file.srcPath, path);
                Security.verifyCheckSum(path, "SHA-256", file.chkSum);
                if (!this.canceled.get()) continue;
                this.cleanup(targetPath);
                boolean bl = false;
                return bl;
            }
            this.enableClose(false);
            Logger.log(2, Messages.get("log.finishInstallation"));
            this.renameDownloadedFiles(diff.updates);
            this.renameManifest();
            try {
                this.deleteWastedFiles(diff.getDeletes());
                this.deleteFiles(targetPath, RENAMED_ORG_EXTENSION);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.log(1, Messages.get("log.errorOccurred"));
            this.cleanup(targetPath);
            throw e;
        }
        finally {
            if (this.logUI != null) {
                this.logUI.removeActionListener(closeListener);
            }
            this.enableClose(true);
        }
    }

    private void cleanup(Path targetPath) {
        this.newJREVersion = this.orgJREVersion;
        this.newVPName = this.orgVPName;
        this.deleteFiles(targetPath, DOWNLOADED_EXTENSION);
    }

    public String getJREVersion() {
        if (this.newJREVersion == null) {
            try {
                this.newJREVersion = this.readJREFromManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.newJREVersion;
    }

    public String getLauncherName() {
        if (this.newVPName == null) {
            try {
                this.newVPName = this.readVPNameFromManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.newVPName;
    }

    protected abstract String getManifestFileName();

    private void enableClose(boolean enable) {
        if (this.logUI != null) {
            this.logUI.setCloseEnabled(enable);
        }
    }

    private String readVPNameFromManifest() throws IOException {
        return this.readInfoFromManifest("#vp-name=");
    }

    private String readJREFromManifest() throws IOException {
        return this.readInfoFromManifest("#jre=");
    }

    private String readInfoFromManifest(String prefix) throws IOException {
        Path manifestPath = Path.of(this.targetDir, this.getManifestFileName());
        if (!Files.exists(manifestPath, new LinkOption[0])) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(manifestPath.toFile());
             CsvInputStreamReader reader = new CsvInputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            while (true) {
                if (reader.ready()) {
                    List line = reader.readLine();
                    if (line.isEmpty()) continue;
                    if (!((String)line.getFirst()).startsWith(prefix)) continue;
                    String string = ((String)line.getFirst()).substring(prefix.length()).trim();
                    return string;
                    continue;
                }
                break;
            }
        }
        return null;
    }

    private List<FileInfo> downloadManifest() throws IOException, URISyntaxException {
        Logger.log(3, Messages.get("log.downloadManifest"));
        Path targetPath = Path.of(this.targetDir, this.getManifestFileName() + DOWNLOADED_EXTENSION);
        this.downloader.download(this.getManifestFileName(), targetPath);
        return this.getFileListFromManifest(targetPath, true);
    }

    private List<FileInfo> getFileListFromManifest(Path manifestPath, boolean installJRE) throws IOException, URISyntaxException {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        int lineCounter = 0;
        try (FileInputStream in = new FileInputStream(manifestPath.toFile());
             CsvInputStreamReader reader = new CsvInputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            while (reader.ready()) {
                List line = reader.readLine();
                ++lineCounter;
                if (line.isEmpty()) continue;
                if (((String)line.getFirst()).startsWith("#jre=")) {
                    if (installJRE) {
                        this.newJREVersion = ((String)line.getFirst()).substring("#jre=".length()).trim();
                        this.installJRE(manifestPath.getParent());
                        continue;
                    }
                    this.orgJREVersion = ((String)line.getFirst()).substring("#jre=".length()).trim();
                    continue;
                }
                if (((String)line.getFirst()).startsWith("#vp-name=")) {
                    if (installJRE) {
                        this.newVPName = ((String)line.getFirst()).substring("#vp-name=".length()).trim();
                        continue;
                    }
                    this.orgVPName = ((String)line.getFirst()).substring("#vp-name=".length()).trim();
                    continue;
                }
                if (((String)line.getFirst()).startsWith("#vp-name=") || ((String)line.getFirst()).startsWith("#vp-dir=") || ((String)line.getFirst()).startsWith("#src-url=")) continue;
                if (line.size() < 3) {
                    throw new RuntimeException(Messages.get("error.invalidManifestLine", lineCounter));
                }
                FileInfo fileInfo = new FileInfo((String)line.get(0), (String)line.get(1), Instant.parse((CharSequence)line.get(2)));
                files.add(fileInfo);
            }
        }
        files.sort(Comparator.comparing(f -> f.srcPath));
        return files;
    }

    private void installJRE(Path starterTargetPath) throws IOException, URISyntaxException {
        if (JREInstaller.start(this.newJREVersion, this.logUI, () -> this.cleanup(starterTargetPath))) {
            this.updated = true;
        }
    }

    private Differences getDiff(List<FileInfo> files) throws IOException, URISyntaxException {
        Logger.log(3, Messages.get("log.buildDifferenceList"));
        Path targetPath = Path.of(this.targetDir, this.getManifestFileName());
        List<FileInfo> org = targetPath.toFile().exists() ? this.getFileListFromManifest(targetPath, false) : null;
        return new Differences(org, files);
    }

    private void renameDownloadedFiles(List<FileInfo> files) throws IOException {
        try {
            for (FileInfo file : files) {
                this.renameFile(file.srcPath);
            }
        }
        catch (IOException e) {
            File[] renamed = new File(this.targetDir).listFiles(f -> f.getName().endsWith(RENAMED_ORG_EXTENSION));
            if (renamed == null) {
                throw e;
            }
            for (File renamedFile : renamed) {
                Path orgPath = Path.of(FileNames.getNameWithoutLastExtension((String)renamedFile.getAbsolutePath()), new String[0]);
                try {
                    Files.move(renamedFile.toPath(), orgPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void renameManifest() throws IOException {
        this.renameFile(this.getManifestFileName());
    }

    private void renameFile(String file) throws IOException {
        Path orgPath = Path.of(this.targetDir, file);
        Path renPath = Path.of(this.targetDir, file + RENAMED_ORG_EXTENSION);
        if (Files.exists(orgPath, new LinkOption[0])) {
            Files.move(orgPath, renPath, StandardCopyOption.REPLACE_EXISTING);
        }
        Path newPath = Path.of(this.targetDir, file + DOWNLOADED_EXTENSION);
        Files.move(newPath, orgPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteWastedFiles(List<FileInfo> files) {
        if (!files.isEmpty()) {
            Logger.log(2, Messages.get("log.deletingFiles"));
        }
        for (FileInfo file : files) {
            Path.of(this.targetDir, file.srcPath).toFile().delete();
        }
    }

    private void deleteFiles(Path dir, String extension) {
        File[] files = dir.toFile().listFiles(f -> f.isDirectory() || f.getName().endsWith(extension));
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.deleteFiles(file.toPath(), extension);
                continue;
            }
            file.delete();
        }
    }

    private static class Differences {
        private final List<FileInfo> updates;
        private final List<FileInfo> deletes = new ArrayList<FileInfo>();

        public Differences(List<FileInfo> orgFiles, List<FileInfo> newFiles) {
            if (orgFiles == null) {
                this.updates = newFiles;
            } else {
                this.updates = new ArrayList<FileInfo>();
                int o = 0;
                for (int n = 0; o < orgFiles.size() && n < newFiles.size(); ++o, ++n) {
                    FileInfo orgFile = orgFiles.get(o);
                    FileInfo newFile = newFiles.get(n);
                    while (orgFile.srcPath.compareTo(newFile.srcPath) < 0) {
                        this.deletes.add(orgFile);
                        if (++o == orgFiles.size()) break;
                        orgFile = orgFiles.get(o);
                    }
                    while (newFile.srcPath.compareTo(orgFile.srcPath) < 0) {
                        this.updates.add(newFile);
                        if (++n == newFiles.size()) break;
                        newFile = newFiles.get(n);
                    }
                    if (newFile.equals(orgFile)) continue;
                    this.updates.add(newFile);
                }
            }
        }

        public List<FileInfo> getUpdates() {
            return Collections.unmodifiableList(this.updates);
        }

        public List<FileInfo> getDeletes() {
            return Collections.unmodifiableList(this.deletes);
        }
    }

    private static class FileInfo {
        public final String srcPath;
        public final String chkSum;
        public final Instant timestamp;

        private FileInfo(String srcPath, String chkSum, Instant timestamp) {
            this.srcPath = srcPath;
            this.chkSum = chkSum;
            this.timestamp = timestamp;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileInfo) {
                FileInfo o = (FileInfo)obj;
                return this.srcPath.equals(o.srcPath) && this.timestamp.equals(o.timestamp);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.srcPath, this.timestamp);
        }
    }
}

