/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.install;

import de.ganzer.core.OS;
import de.velocom.veloport.core.download.HTTPSTemurinDownloader;
import de.velocom.veloport.core.gui.LogUI;
import de.velocom.veloport.core.gui.LogUICloseListener;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.logging.Logger;
import de.velocom.veloport.core.util.FileSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class JREInstaller {
    private static final AtomicBoolean canceled = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(String jreVersion, final LogUI logUI, final Runnable cleanup) throws IOException, URISyntaxException {
        canceled.set(false);
        if (Files.exists(JREInstaller.getJavaExecutablePath(jreVersion), new LinkOption[0])) {
            return false;
        }
        Logger.log(2, Messages.get("log.downloadingJRE", jreVersion));
        class QuitListener
        implements ActionListener {
            QuitListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cleanup != null) {
                    cleanup.run();
                }
                logUI.close();
            }
        }
        QuitListener quitListener = new QuitListener();
        logUI.addActionListener(quitListener);
        HTTPSTemurinDownloader downloader = new HTTPSTemurinDownloader();
        File file = downloader.download(jreVersion);
        String name = file.getName().toLowerCase();
        logUI.removeActionListener(quitListener);
        LogUICloseListener closeListener = new LogUICloseListener(logUI.getTitle(), () -> canceled.set(true));
        logUI.addActionListener(closeListener);
        try {
            Logger.log(2, Messages.get("log.installingJRE"));
            if (name.endsWith(".zip")) {
                JREInstaller.unzip(file, JREInstaller.getInstallDir(jreVersion));
            } else {
                JREInstaller.untarGz(file, JREInstaller.getInstallDir(jreVersion));
            }
        }
        finally {
            file.delete();
            logUI.removeActionListener(closeListener);
            if (canceled.get()) {
                JREInstaller.cleanup(new File(JREInstaller.getInstallDir(jreVersion)));
                logUI.close();
            }
        }
        return true;
    }

    public static String getInstallDir(String jreVersion) {
        return Path.of(System.getProperty("user.home"), String.format(".cache/velo.port/jre/%s", jreVersion)).toString();
    }

    public static Path getJavaExecutablePath(String jreVersion) {
        String dir;
        File[] dirs = new File(JREInstaller.getInstallDir(jreVersion)).listFiles(File::isDirectory);
        String string = dir = dirs == null || dirs.length == 0 ? "" : dirs[0].getName();
        if (OS.isMac()) {
            return Path.of(JREInstaller.getInstallDir(jreVersion), dir, "Contents", "Home", "bin", FileSystem.getExecutableJavaName());
        }
        return Path.of(JREInstaller.getInstallDir(jreVersion), dir, "bin", FileSystem.getExecutableJavaName());
    }

    private static void cleanup(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                JREInstaller.cleanup(file);
                continue;
            }
            file.delete();
        }
    }

    private static void unzip(File zipFile, String targetDir) throws IOException {
        try (FileInputStream in = new FileInputStream(zipFile);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry entry;
            int counter = 0;
            while (!canceled.get() && (entry = zis.getNextEntry()) != null) {
                Logger.log(2, Messages.get("log.installingFile", entry.getName()));
                ++counter;
                Path targetPath = Path.of(targetDir, entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
            }
            if (counter == 0) {
                Logger.log(1, Messages.get("log.cannotReadJREArchive"));
            }
        }
    }

    private static void untarGz(File file, String targetDir) throws IOException {
        try (FileInputStream fi = new FileInputStream(file);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
             TarArchiveInputStream tai = new TarArchiveInputStream((InputStream)gzi);){
            TarArchiveEntry entry;
            int counter = 0;
            while (!canceled.get() && (entry = tai.getNextEntry()) != null) {
                Logger.log(2, Messages.get("log.installingFile", entry.getName()));
                ++counter;
                Path targetPath = Path.of(targetDir, entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                    tai.transferTo(out);
                }
                if (OS.isWindows()) continue;
                Files.setPosixFilePermissions(targetPath, JREInstaller.modeToPermissions(entry.getMode()));
            }
            if (counter == 0) {
                Logger.log(1, Messages.get("log.cannotReadJREArchive"));
            }
        }
    }

    private static Set<PosixFilePermission> modeToPermissions(int mode) {
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }
}

