/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.install;

import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.install.LauncherInstaller;
import de.velocom.veloport.core.install.LauncherInstallerException;
import de.velocom.veloport.core.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class LinuxLauncherInstaller
implements LauncherInstaller {
    private final Path jarPath;
    private final Path javaPath;

    public LinuxLauncherInstaller() {
        this.jarPath = null;
        this.javaPath = null;
    }

    public LinuxLauncherInstaller(Path jarPath, Path javaPath) {
        this.jarPath = jarPath;
        this.javaPath = javaPath;
    }

    @Override
    public void installLauncher(String launcherName, Path manifestPath, boolean force) throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createLinuxIcon(false);
            this.createLinuxIcon(true);
            this.createLauncher(false, false, launcherName, manifestPath);
            this.createLauncher(true, false, launcherName, manifestPath);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void installConfigLauncher() throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createLauncher(false, true, null, null);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeLauncher(String launcherName) throws LauncherInstallerException {
        try {
            Files.deleteIfExists(Path.of(this.getDesktopDirectory(), launcherName + ".desktop"));
            Files.deleteIfExists(Path.of(System.getProperty("user.home"), ".local", "share", "applications", launcherName + ".desktop"));
        }
        catch (IOException e) {
            throw new LauncherInstallerException(Messages.get("error.removeLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeConfigLauncher() throws LauncherInstallerException {
        try {
            Files.deleteIfExists(Path.of(System.getProperty("user.home"), ".local", "share", "applications", Messages.get("velo.port.launcher.config") + ".desktop"));
        }
        catch (IOException e) {
            throw new LauncherInstallerException(Messages.get("error.removeLauncher", e.getLocalizedMessage()), e);
        }
    }

    private void createLauncher(boolean desktop, boolean config, String launcherName, Path manifestPath) throws IOException {
        String name = config ? Messages.get("velo.port.launcher.config") : launcherName;
        Path targetPath = desktop ? Path.of(this.getDesktopDirectory(), new String[0]) : Path.of(System.getProperty("user.home"), ".local", "share", "applications");
        this.createLauncher(targetPath.toString(), name, config, manifestPath, desktop);
    }

    private String getDesktopDirectory() throws IOException {
        String home = System.getenv("HOME");
        File xdgFile = new File(home + "/.config/user-dirs.dirs");
        if (xdgFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(xdgFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("XDG_DESKTOP_DIR")) continue;
                    int start = line.indexOf("\"") + 1;
                    int end = line.lastIndexOf("\"");
                    String string = line.substring(start, end).replace("$HOME", home);
                    return string;
                }
            }
        }
        return home + "/Desktop";
    }

    private void createLauncher(String targetDir, String name, boolean config, Path manifestPath, boolean executable) throws IOException {
        assert (this.jarPath != null);
        String manPath = manifestPath != null ? String.format("\"%s\"", manifestPath) : "";
        String content = "[Desktop Entry]\nType=Application\nName=%s\nComment=%s\nExec=\"%s\" -jar \"%s\" %s %%F\nIcon=%s\nPath=%s\nTerminal=false\nCategories=Utility;\n".formatted(name, Messages.get("velo.port.launcher.description"), this.javaPath, this.jarPath, config ? " --configure" : manPath, Path.of(this.jarPath.getParent().toString(), config ? "config-icon.png" : "icon.png"), this.jarPath.getParent());
        Path target = Path.of(targetDir, name + ".desktop");
        File file = target.toFile();
        FileWriter writer = new FileWriter(file);
        writer.write(content);
        writer.close();
        if (executable) {
            file.setExecutable(true);
        }
    }

    private void createLinuxIcon(boolean config) throws IOException {
        assert (this.jarPath != null);
        Logger.log(3, Messages.get("log.createIcon"));
        String iconName = config ? "config-icon.png" : "icon.png";
        Path iconPath = Path.of(this.jarPath.getParent().toString(), iconName);
        String resName = config ? "/de/velocom/veloport/core/icons/vp_config_icon_256.png" : "/de/velocom/veloport/core/icons/vp_icon_256.png";
        try (InputStream in = this.getClass().getResourceAsStream(resName);){
            if (in == null) {
                throw new IOException("Resource \"" + resName + "\" not found in JAR");
            }
            Files.copy(in, iconPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

