/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.actions;

import de.ganzer.swing.actions.GAction;
import de.ganzer.swing.actions.GActionItemBuilder;
import de.ganzer.swing.actions.GSeparatorAction;
import de.ganzer.swing.actions.GToggleActionGroup;
import de.ganzer.swing.controls.GMenu;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class GActionGroup
extends GAction
implements Iterable<GActionItemBuilder> {
    private final List<GActionItemBuilder> actions = new ArrayList<GActionItemBuilder>();

    public GActionGroup() {
    }

    public GActionGroup(String name) {
        super(name);
    }

    public GActionGroup addAll(GActionItemBuilder ... actions) {
        Objects.requireNonNull(actions, "actions must not be null.");
        for (GActionItemBuilder action : List.of(actions)) {
            Objects.requireNonNull(action, "actions must not contain null values.");
            this.actions.add(action);
        }
        return this;
    }

    @Override
    public GActionGroup name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public GActionGroup command(String command) {
        super.command(command);
        return this;
    }

    @Override
    public GActionGroup largeIcon(Icon icon) {
        super.largeIcon(icon);
        return this;
    }

    @Override
    public GActionGroup mnemonic(Integer keyCode) {
        super.mnemonic(keyCode);
        return this;
    }

    @Override
    public GActionGroup displayedMnemonicIndex(Integer index) {
        super.displayedMnemonicIndex(index);
        return this;
    }

    @Override
    public GActionGroup shortDescription(String description) {
        super.shortDescription(description);
        return this;
    }

    @Override
    public GActionGroup longDescription(String description) {
        super.longDescription(description);
        return this;
    }

    @Override
    public GActionGroup visible(boolean visible) {
        super.visible(visible);
        return this;
    }

    @Override
    public GActionGroup enabled(boolean enabled) {
        super.enabled(enabled);
        return this;
    }

    @Override
    public GActionGroup onAction(ActionListener listener) {
        super.onAction(listener);
        return this;
    }

    @Override
    public JMenu createMenu() {
        GMenu menu = new GMenu(this);
        this.addMenuItems(menu);
        return menu;
    }

    @Override
    public void addMenus(JMenuBar target) {
        Objects.requireNonNull(target, "target must not be null.");
        for (GActionItemBuilder builder : this.actions) {
            JMenu menu = builder.createMenu();
            if (menu == null) continue;
            target.add(menu);
        }
    }

    @Override
    public void addMenuItems(JMenu target) {
        Objects.requireNonNull(target, "target must not be null.");
        for (GActionItemBuilder builder : this.actions) {
            if (builder instanceof GActionGroup) {
                target.add(builder.createMenu());
                continue;
            }
            builder.addMenuItems(target);
        }
    }

    @Override
    public void addMenuItems(JPopupMenu target) {
        for (GActionItemBuilder builder : this.actions) {
            if (builder instanceof GActionGroup) {
                target.add(builder.createMenu());
                continue;
            }
            if (builder instanceof GToggleActionGroup) {
                builder.addMenuItems(target);
                continue;
            }
            if (builder instanceof GSeparatorAction) {
                target.addSeparator();
                continue;
            }
            target.add(builder.createMenuItem());
        }
    }

    @Override
    public AbstractButton createButton(int options) {
        final JPopupMenu menu = this.createPopupMenu();
        AbstractButton button = super.createButton(options);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return button;
    }

    @Override
    public void addButtons(JToolBar target, int options) {
        Objects.requireNonNull(target, "target must not be null.");
        for (GActionItemBuilder builder : this.actions) {
            if (builder instanceof GActionGroup) {
                target.add(builder.createButton(options));
                continue;
            }
            builder.addButtons(target, options);
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.addMenuItems(menu);
        return menu;
    }

    @Override
    public Iterator<GActionItemBuilder> iterator() {
        return this.actions.iterator();
    }
}

