/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public class BOMInputStreamReader
extends Reader {
    private final PushbackInputStream in;
    private final StreamDecoder sd;

    public BOMInputStreamReader(InputStream in) throws IOException {
        super(in);
        this.in = new PushbackInputStream(in, 4);
        this.sd = this.getDecoder(Charset.defaultCharset());
    }

    public BOMInputStreamReader(InputStream in, String charsetName) throws IOException {
        super(in);
        this.in = new PushbackInputStream(in, 4);
        this.sd = this.getDecoder(Charset.forName(charsetName));
    }

    public BOMInputStreamReader(InputStream in, Charset cs) throws IOException {
        super(in);
        this.in = new PushbackInputStream(in, 4);
        this.sd = this.getDecoder(cs);
    }

    public String getEncoding() {
        return this.sd.getEncoding();
    }

    @Override
    public int read() throws IOException {
        return this.sd.read();
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        Objects.requireNonNull(buf, "buf must not be null.");
        return this.sd.read(buf, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        return this.sd.ready();
    }

    @Override
    public void close() throws IOException {
        this.sd.close();
    }

    private BOM getBOM() throws IOException {
        byte[] buff = new byte[4];
        int read = this.in.read(buff, 0, 4);
        if (read < 1) {
            return BOM.NONE;
        }
        BOM bom = BOM.getBOM(buff);
        int bytesLeft = read - bom.getNumBytes();
        if (bytesLeft > 0) {
            this.in.unread(buff, bom.getNumBytes(), bytesLeft);
        }
        return bom;
    }

    private StreamDecoder getDecoder(Charset cs) throws IOException {
        Objects.requireNonNull(cs, "Charset must not be null");
        Charset set = switch (this.getBOM()) {
            case BOM.UTF_32_BE -> Charset.forName("UTF_32BE");
            case BOM.UTF_32_LE -> Charset.forName("UTF_32LE");
            case BOM.UTF_8 -> StandardCharsets.UTF_8;
            case BOM.UTF_16_BE -> StandardCharsets.UTF_16BE;
            case BOM.UTF_16_LE -> StandardCharsets.UTF_16LE;
            default -> cs;
        };
        return StreamDecoder.forInputStreamReader((InputStream)this.in, (Object)this, set);
    }

    private static class StreamDecoder
    extends Reader {
        private static final int MIN_BYTE_BUFFER_SIZE = 32;
        private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
        private volatile boolean closed;
        private final Charset cs;
        private final CharsetDecoder decoder;
        private final ByteBuffer bb;
        private final InputStream in;
        private final ReadableByteChannel ch;
        private boolean haveLeftoverChar = false;
        private char leftoverChar;

        public static StreamDecoder forInputStreamReader(InputStream in, Object lock, String charsetName) throws UnsupportedEncodingException {
            String csn = charsetName;
            if (csn == null) {
                csn = Charset.defaultCharset().name();
            }
            try {
                return new StreamDecoder(in, lock, Charset.forName(csn));
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException x) {
                throw new UnsupportedEncodingException(csn);
            }
        }

        public static StreamDecoder forInputStreamReader(InputStream in, Object lock, Charset cs) {
            return new StreamDecoder(in, lock, cs);
        }

        public static StreamDecoder forInputStreamReader(InputStream in, Object lock, CharsetDecoder dec) {
            return new StreamDecoder(in, lock, dec);
        }

        public static StreamDecoder forDecoder(ReadableByteChannel ch, CharsetDecoder dec, int minBufferCap) {
            return new StreamDecoder(ch, dec, minBufferCap);
        }

        public String getEncoding() {
            if (this.isOpen()) {
                return this.encodingName();
            }
            return null;
        }

        @Override
        public int read() throws IOException {
            return this.read0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] buf, int offset, int length) throws IOException {
            int off = offset;
            int len = length;
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                int n = 0;
                if (this.haveLeftoverChar) {
                    buf[off] = this.leftoverChar;
                    ++off;
                    this.haveLeftoverChar = false;
                    n = 1;
                    if (--len == 0 || !this.implReady()) {
                        return n;
                    }
                }
                if (len == 1) {
                    int c = this.read0();
                    if (c == -1) {
                        return n == 0 ? -1 : n;
                    }
                    buf[off] = (char)c;
                    return n + 1;
                }
                return n + this.implRead(buf, off, off + len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return this.haveLeftoverChar || this.implReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                try {
                    this.implClose();
                }
                finally {
                    this.closed = true;
                }
            }
        }

        private StreamDecoder(InputStream in, Object lock, Charset cs) {
            this(in, lock, cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        private StreamDecoder(InputStream in, Object lock, CharsetDecoder dec) {
            super(lock);
            this.cs = dec.charset();
            this.decoder = dec;
            this.in = in;
            this.ch = null;
            this.bb = ByteBuffer.allocate(8192);
            this.bb.flip();
        }

        private StreamDecoder(ReadableByteChannel ch, CharsetDecoder dec, int mbc) {
            this.in = null;
            this.ch = ch;
            this.decoder = dec;
            this.cs = dec.charset();
            this.bb = ByteBuffer.allocate(mbc < 0 ? 8192 : Math.max(mbc, 32));
            this.bb.flip();
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read0() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.haveLeftoverChar) {
                    this.haveLeftoverChar = false;
                    return this.leftoverChar;
                }
                char[] cb = new char[2];
                int n = this.read(cb, 0, 2);
                switch (n) {
                    case -1: {
                        return -1;
                    }
                    case 2: {
                        this.leftoverChar = cb[1];
                        this.haveLeftoverChar = true;
                    }
                    case 1: {
                        return cb[0];
                    }
                }
                assert (false) : n;
                return -1;
            }
        }

        private boolean isOpen() {
            return !this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readBytes() throws IOException {
            this.bb.compact();
            try {
                if (this.ch != null) {
                    int n = this.ch.read(this.bb);
                    if (n < 0) {
                        int n2 = n;
                        return n2;
                    }
                } else {
                    int lim = this.bb.limit();
                    int pos = this.bb.position();
                    assert (pos <= lim);
                    int rem = lim - pos;
                    int n = this.in.read(this.bb.array(), this.bb.arrayOffset() + pos, rem);
                    if (n < 0) {
                        int n3 = n;
                        return n3;
                    }
                    if (n == 0) {
                        throw new IOException("Underlying input stream returned zero bytes");
                    }
                    assert (n <= rem) : "n = " + n + ", rem = " + rem;
                    this.bb.position(pos + n);
                }
            }
            finally {
                this.bb.flip();
            }
            int rem = this.bb.remaining();
            assert (rem != 0) : rem;
            return rem;
        }

        int implRead(char[] cbuf, int off, int end) throws IOException {
            assert (end - off > 1);
            CharBuffer cb = CharBuffer.wrap(cbuf, off, end - off);
            if (cb.position() != 0) {
                cb = cb.slice();
            }
            boolean eof = false;
            while (true) {
                CoderResult cr;
                if ((cr = this.decoder.decode(this.bb, cb, eof)).isUnderflow()) {
                    if (eof || !cb.hasRemaining() || cb.position() > 0 && !this.inReady()) break;
                    int n = this.readBytes();
                    if (n >= 0) continue;
                    eof = true;
                    if (cb.position() == 0 && !this.bb.hasRemaining()) break;
                    this.decoder.reset();
                    continue;
                }
                if (cr.isOverflow()) {
                    assert (cb.position() > 0);
                    break;
                }
                cr.throwException();
            }
            if (eof) {
                this.decoder.reset();
            }
            if (cb.position() == 0) {
                if (eof) {
                    return -1;
                }
                assert (false);
            }
            return cb.position();
        }

        String encodingName() {
            return this.cs.name();
        }

        private boolean inReady() {
            try {
                return this.in != null && this.in.available() > 0 || this.ch instanceof FileChannel;
            }
            catch (IOException x) {
                return false;
            }
        }

        boolean implReady() {
            return this.bb.hasRemaining() || this.inReady();
        }

        void implClose() throws IOException {
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.in.close();
            }
        }
    }

    private static enum BOM {
        UTF_32_BE(new byte[]{0, 0, -2, -1}),
        UTF_32_LE(new byte[]{-1, -2, 0, 0}),
        UTF_8(new byte[]{-17, -69, -65}),
        UTF_16_BE(new byte[]{-2, -1}),
        UTF_16_LE(new byte[]{-1, -2}),
        NONE(new byte[0]);

        private final byte[] bytes;

        private BOM(byte[] bomBytes) {
            this.bytes = bomBytes;
        }

        public int getNumBytes() {
            return this.bytes.length;
        }

        public static BOM getBOM(byte[] bytes) {
            for (BOM bom : BOM.values()) {
                if (!BOM.startsWith(bytes, bom.bytes)) continue;
                return bom;
            }
            return NONE;
        }

        private static boolean startsWith(byte[] bytes, byte[] bom) {
            if (bom.length > bytes.length) {
                return false;
            }
            for (int i = 0; i < bom.length; ++i) {
                if (bytes[i] == bom[i]) continue;
                return false;
            }
            return true;
        }
    }
}

