/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class NormalDistribution
implements Distribution<Double> {
    private final double mean;
    private final double deviation;
    private boolean hasNext;
    private double next;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double mean) {
        this(mean, 1.0);
    }

    public NormalDistribution(double mean, double deviation) {
        this.mean = mean;
        this.deviation = deviation;
    }

    @Override
    public Double next(Random random) {
        double result;
        if (this.hasNext) {
            this.hasNext = false;
            result = this.next;
        } else {
            double v;
            double u;
            double s;
            while ((s = (u = 2.0 * random.nextDouble() - 1.0) * u + (v = 2.0 * random.nextDouble() - 1.0) * v) >= 1.0 || s == 0.0) {
            }
            double f = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
            this.next = v * f;
            this.hasNext = true;
            result = u * f;
        }
        return result * this.deviation + this.mean;
    }
}

