/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.CharCountValidator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;

public class PxPicValidator
extends CharCountValidator {
    private String picture = "";

    public PxPicValidator() {
        super(5);
    }

    public PxPicValidator(int options) {
        super(options);
    }

    public PxPicValidator(String picture) {
        super(5);
        this.setPicture(picture);
    }

    public PxPicValidator(int options, String picture) {
        super(options);
        this.setPicture(picture);
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        if (!this.checkSyntax(picture)) {
            throw new IllegalArgumentException("picture");
        }
        this.picture = picture;
    }

    public boolean checkSyntax(String picture) {
        char prevLastChar;
        if (picture == null || picture.isEmpty()) {
            return true;
        }
        char lastChar = picture.charAt(picture.length() - 1);
        char c = prevLastChar = picture.length() > 1 ? picture.charAt(picture.length() - 2) : (char)'\u0000';
        if (lastChar == ';' && (picture.length() < 2 || prevLastChar != ';')) {
            return false;
        }
        if (lastChar == '*' && (picture.length() < 2 || prevLastChar != ';')) {
            return false;
        }
        int brk_level = 0;
        int brc_level = 0;
        String groups = "[]{}";
        block8: for (int p = 0; p < picture.length(); ++p) {
            switch (picture.charAt(p)) {
                case '*': {
                    if (p + 1 >= picture.length() || groups.indexOf(picture.charAt(p + 1)) < 0) continue block8;
                    return false;
                }
                case '[': {
                    ++brk_level;
                    continue block8;
                }
                case ']': {
                    --brk_level;
                    continue block8;
                }
                case '{': {
                    ++brc_level;
                    continue block8;
                }
                case '}': {
                    --brc_level;
                    continue block8;
                }
                case ';': {
                    ++p;
                }
            }
        }
        return brk_level == 0 && brc_level == 0;
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        if (!super.doInputValidation(text, autoFill)) {
            return false;
        }
        if (this.picture == null || this.picture.isEmpty() || text.length() == 0) {
            return true;
        }
        switch (new StateMachine(this.picture, text).start(autoFill)) {
            case COMPLETE: 
            case AMBIGUOUS: 
            case INCOMPLETE: 
            case INCOMPLETE_NO_FILL: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (this.picture == null || this.picture.isEmpty() || text.isEmpty()) {
            return true;
        }
        switch (new StateMachine(this.picture, new StringBuilder(text)).start(false)) {
            case COMPLETE: 
            case EMPTY: {
                return true;
            }
            case SYNTAX: {
                er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : String.format(CoreMessages.get("picSyntaxError"), this.picture)));
                return false;
            }
        }
        er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : String.format(CoreMessages.get("inputDoesNotConfirmPic"), this.picture)));
        return false;
    }

    private static class StateMachine {
        private final String picture;
        private final StringBuilder input;
        private int idxPic;
        private int idxInp;

        public StateMachine(String picture, StringBuilder input) {
            this.picture = picture;
            this.input = input;
        }

        public Status start(boolean fill) {
            if (this.input.length() == 0) {
                return Status.EMPTY;
            }
            this.idxInp = 0;
            this.idxPic = 0;
            Status result = this.process(this.picture.length());
            if (result != Status.ERROR && result != Status.SYNTAX && this.idxInp < this.input.length()) {
                result = Status.ERROR;
            }
            if (result == Status.INCOMPLETE && fill) {
                boolean reprocess = false;
                String specchars = "#?&!@*{}[],";
                while (this.idxPic < this.picture.length() && specchars.indexOf(this.picture.charAt(this.idxPic)) < 0) {
                    if (this.picture.charAt(this.idxPic) == ';') {
                        ++this.idxPic;
                    }
                    this.input.insert(this.idxInp++, this.picture.charAt(this.idxPic++));
                    reprocess = true;
                }
                if (reprocess) {
                    this.idxInp = 0;
                    this.idxPic = 0;
                    result = this.process(this.picture.length());
                }
            }
            if (result == Status.AMBIGUOUS) {
                return Status.COMPLETE;
            }
            if (result == Status.INCOMPLETE_NO_FILL) {
                return Status.INCOMPLETE;
            }
            return result;
        }

        private Status process(int term) {
            Status result;
            int incompleteJ = 0;
            int incompleteI = 0;
            boolean incomplete = false;
            int oldI = this.idxPic;
            int oldJ = this.idxInp;
            do {
                if (((result = this.scan(term)) == Status.COMPLETE || result == Status.AMBIGUOUS) && incomplete && this.idxInp < incompleteJ) {
                    result = Status.INCOMPLETE;
                    this.idxInp = incompleteJ;
                }
                if (result != Status.ERROR && result != Status.INCOMPLETE) continue;
                if (!incomplete && result == Status.INCOMPLETE) {
                    incomplete = true;
                    incompleteI = this.idxPic;
                    incompleteJ = this.idxInp;
                }
                this.idxPic = oldI;
                this.idxInp = oldJ;
                if (!this.skipToComma(term)) {
                    if (incomplete) {
                        this.idxPic = incompleteI;
                        this.idxInp = incompleteJ;
                        return Status.INCOMPLETE;
                    }
                    return result;
                }
                oldI = this.idxPic;
            } while (result == Status.ERROR || result == Status.INCOMPLETE);
            return result == Status.COMPLETE && incomplete ? Status.AMBIGUOUS : result;
        }

        private Status scan(int term) {
            Status result = Status.EMPTY;
            int len = this.input.length();
            while (this.idxPic != term && this.picture.charAt(this.idxPic) != ',') {
                if (this.idxInp >= len) {
                    return this.checkComplete(term, result);
                }
                char ch = this.input.charAt(this.idxInp);
                switch (this.picture.charAt(this.idxPic)) {
                    case '#': {
                        if (!Character.isDigit(ch)) {
                            return Status.ERROR;
                        }
                        ++this.idxInp;
                        ++this.idxPic;
                        break;
                    }
                    case '?': {
                        if (!Character.isLetter(ch)) {
                            return Status.ERROR;
                        }
                        ++this.idxInp;
                        ++this.idxPic;
                        break;
                    }
                    case '&': {
                        if (!Character.isLetter(ch)) {
                            return Status.ERROR;
                        }
                        this.input.setCharAt(this.idxInp++, Character.toUpperCase(ch));
                        ++this.idxPic;
                        break;
                    }
                    case '!': {
                        this.input.setCharAt(this.idxInp++, Character.toUpperCase(ch));
                        ++this.idxPic;
                        break;
                    }
                    case '@': {
                        ++this.idxInp;
                        ++this.idxPic;
                        break;
                    }
                    case '*': {
                        result = this.iteration(term);
                        if (!this.isComplete(result)) {
                            return result;
                        }
                        if (result != Status.ERROR) break;
                        result = Status.AMBIGUOUS;
                        break;
                    }
                    case '{': {
                        result = this.group(term);
                        if (this.isComplete(result)) break;
                        return result;
                    }
                    case '[': {
                        result = this.group(term);
                        if (this.isIncomplete(result)) {
                            return result;
                        }
                        if (result != Status.ERROR) break;
                        result = Status.AMBIGUOUS;
                        break;
                    }
                    default: {
                        if (this.picture.charAt(this.idxPic) == ';') {
                            ++this.idxPic;
                        }
                        if (Character.toUpperCase(this.picture.charAt(this.idxPic)) != Character.toUpperCase(ch) && ch != ' ') {
                            return Status.ERROR;
                        }
                        this.input.setCharAt(this.idxInp++, this.picture.charAt(this.idxPic++));
                    }
                }
                if (result == Status.AMBIGUOUS) {
                    result = Status.INCOMPLETE_NO_FILL;
                    continue;
                }
                result = Status.INCOMPLETE;
            }
            return result == Status.INCOMPLETE_NO_FILL ? Status.AMBIGUOUS : Status.COMPLETE;
        }

        private Status checkComplete(int term, Status result) {
            int j = this.idxPic;
            if (this.isIncomplete(result)) {
                boolean loop = true;
                while (loop) {
                    switch (this.picture.charAt(j)) {
                        case '[': {
                            j = this.toGroupEnd(term, j);
                            break;
                        }
                        case '*': {
                            if (j < term && !Character.isDigit(this.picture.charAt(j + 1))) {
                                ++j;
                            }
                            j = this.toGroupEnd(term, j);
                            break;
                        }
                        default: {
                            loop = false;
                        }
                    }
                    if (j != term) continue;
                    return Status.AMBIGUOUS;
                }
            }
            return result;
        }

        private int toGroupEnd(int term, int pos) {
            int brk_level = 0;
            int brc_level = 0;
            int newPos = pos;
            do {
                if (newPos == term) {
                    return newPos;
                }
                switch (this.picture.charAt(newPos)) {
                    case '[': {
                        ++brk_level;
                        break;
                    }
                    case ']': {
                        --brk_level;
                        break;
                    }
                    case '{': {
                        ++brc_level;
                        break;
                    }
                    case '}': {
                        --brc_level;
                        break;
                    }
                    case ';': {
                        ++newPos;
                    }
                }
                ++newPos;
            } while (brk_level > 0 || brc_level > 0);
            return newPos;
        }

        private boolean isComplete(Status result) {
            return result == Status.COMPLETE || result == Status.AMBIGUOUS;
        }

        private boolean isIncomplete(Status result) {
            return result == Status.INCOMPLETE || result == Status.INCOMPLETE_NO_FILL;
        }

        private boolean skipToComma(int term) {
            do {
                this.idxPic = this.toGroupEnd(term, this.idxPic);
                if (this.idxPic != term) continue;
                return false;
            } while (this.picture.charAt(this.idxPic) != ',');
            return ++this.idxPic < term;
        }

        private Status group(int term) {
            int grpterm = this.calcTerm(term, this.idxPic);
            ++this.idxPic;
            Status rslt = this.process(grpterm - 1);
            if (!this.isIncomplete(rslt)) {
                this.idxPic = grpterm;
            }
            return rslt;
        }

        private int calcTerm(int term, int pos) {
            return this.toGroupEnd(term, pos);
        }

        private Status iteration(int term) {
            ++this.idxPic;
            Status rslt = Status.ERROR;
            int itr = 0;
            while (this.idxPic < term && Character.isDigit(this.picture.charAt(this.idxPic))) {
                itr = itr * 10 + this.digitValue(this.picture.charAt(this.idxPic));
                ++this.idxPic;
            }
            if (this.idxPic == term) {
                return Status.SYNTAX;
            }
            int k = this.idxPic;
            int t = this.calcTerm(term, this.idxPic);
            if (itr != 0) {
                for (int m = 0; m < itr; ++m) {
                    this.idxPic = k;
                    rslt = this.process(t);
                    if (this.isComplete(rslt)) continue;
                    if (rslt == Status.EMPTY) {
                        rslt = Status.INCOMPLETE;
                    }
                    return rslt;
                }
            } else {
                do {
                    this.idxPic = k;
                } while (this.isComplete(rslt = this.process(t)));
                if (rslt == Status.EMPTY || rslt == Status.ERROR) {
                    ++this.idxPic;
                    rslt = Status.AMBIGUOUS;
                }
            }
            this.idxPic = t;
            return rslt;
        }

        private int digitValue(char ch) {
            return ch - 48;
        }
    }

    private static enum Status {
        COMPLETE,
        INCOMPLETE,
        EMPTY,
        ERROR,
        SYNTAX,
        AMBIGUOUS,
        INCOMPLETE_NO_FILL;

    }
}

