/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import de.ganzer.swing.controls.TogglePanel;
import java.awt.Component;
import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

@JavaBean(defaultProperty="iconsVisible", description="A component which provides a collection of collapsable containers.")
public class Accordion
extends JPanel
implements Iterable<TogglePanel> {
    public static final String ICON_VISIBLE_PROPERTY = "iconVisible";
    public static final String HORIZONTAL_ALIGNMENT_PROPERTY = "horizontalAlignment";
    public static final String FOCUSABLE_PROPERTY = "focusable";
    private final List<TogglePanel> panels = new ArrayList<TogglePanel>();
    private boolean iconsVisible;
    private int horizontalAlignment = 10;
    private boolean focusable = true;

    public Accordion() {
        this(true);
    }

    public Accordion(boolean iconsVisible) {
        this.setLayout(new BoxLayout(this, 3));
        this.iconsVisible = iconsVisible;
    }

    public boolean isIconsVisible() {
        return this.iconsVisible;
    }

    @BeanProperty(visualUpdate=true, description="The visibility of the icons in the contained toggle panels.")
    public void setIconsVisible(boolean iconsVisible) {
        if (this.iconsVisible == iconsVisible) {
            return;
        }
        boolean orgIconVisible = this.iconsVisible;
        this.iconsVisible = iconsVisible;
        for (TogglePanel panel : this.panels) {
            panel.setIconVisible(iconsVisible);
        }
        this.firePropertyChange(ICON_VISIBLE_PROPERTY, orgIconVisible, iconsVisible);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @BeanProperty(visualUpdate=true, enumerationValues={"SwingConstants.LEFT", "SwingConstants.CENTER", "SwingConstants.RIGHT", "SwingConstants.LEADING", "SwingConstants.TRAILING"}, description="The horizontal alignment of the text of the contained toggle panels.")
    public void setHorizontalAlignment(int horizontalAlignment) {
        if (this.horizontalAlignment == horizontalAlignment) {
            return;
        }
        int orgAlignment = this.horizontalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        for (TogglePanel panel : this.panels) {
            panel.setHorizontalAlignment(orgAlignment);
        }
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_PROPERTY, orgAlignment, this.horizontalAlignment);
    }

    public TogglePanel[] getPanels() {
        return this.panels.toArray(new TogglePanel[0]);
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    @BeanProperty(visualUpdate=true, description="The focusable state of the contained toggle panels.")
    public void setFocusable(boolean focusable) {
        if (this.focusable == focusable) {
            return;
        }
        boolean orgFocusable = this.focusable;
        this.focusable = focusable;
        for (TogglePanel panel : this.panels) {
            panel.setFocusable(focusable);
        }
        this.firePropertyChange(FOCUSABLE_PROPERTY, orgFocusable, focusable);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        int newWidth = this.getWidth();
        for (TogglePanel panel : this.panels) {
            panel.setSize(newWidth, panel.getHeight());
        }
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        this.panels.get(index).removePropertyChangeListener("collapsed", this::onPanelToggled);
        this.panels.remove(index);
    }

    @Override
    public Iterator<TogglePanel> iterator() {
        return this.panels.iterator();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof TogglePanel)) {
            throw new IllegalArgumentException("Panels must be of type TogglePanel");
        }
        TogglePanel panel = (TogglePanel)comp;
        panel.setCollapsed(true);
        panel.setIconVisible(this.iconsVisible);
        panel.setHorizontalAlignment(this.horizontalAlignment);
        panel.setFocusable(this.focusable);
        panel.addPropertyChangeListener("collapsed", this::onPanelToggled);
        this.panels.add(panel);
        super.addImpl(comp, constraints, index);
    }

    private void onPanelToggled(PropertyChangeEvent event) {
        if (((Boolean)event.getNewValue()).booleanValue()) {
            return;
        }
        for (TogglePanel panel : this.panels) {
            if (panel == event.getSource()) continue;
            panel.setCollapsed(true);
        }
    }
}

