/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.validaton;

import de.ganzer.core.validation.TextFormat;
import de.ganzer.core.validation.Validator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;
import de.ganzer.swing.internals.SwingMessages;
import de.ganzer.swing.validaton.BorderValidationHint;
import de.ganzer.swing.validaton.ValidationBehavior;
import de.ganzer.swing.validaton.ValidationHintProvider;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class ValidationFilter
extends DocumentFilter {
    private static Consumer<ValidatorException> errorConsumer;
    private static ValidationHintProvider hintProvider;
    private final JTextComponent textField;
    private Validator validator;
    private boolean validateOnFocusLost;
    private boolean hintsVisible;
    private boolean updating;

    public ValidationFilter(Validator validator, JTextComponent textField) {
        this(validator, textField, true);
    }

    public ValidationFilter(Validator validator, JTextComponent textField, boolean validateOnFocusLost) {
        Objects.requireNonNull(validator, "validator must not be null.");
        Objects.requireNonNull(textField, "textField must not be null.");
        this.validator = validator;
        this.textField = textField;
        this.validateOnFocusLost = validateOnFocusLost;
        ((AbstractDocument)textField.getDocument()).setDocumentFilter(this);
        this.setListeners();
    }

    public static ValidationHintProvider getHintProvider() {
        return hintProvider;
    }

    public static void setHintProvider(ValidationHintProvider hintProvider) {
        ValidationFilter.hintProvider = hintProvider == null ? new BorderValidationHint() : hintProvider;
    }

    public static Consumer<ValidatorException> getErrorConsumer() {
        return errorConsumer;
    }

    public static void setErrorConsumer(Consumer<ValidatorException> errorConsumer) {
        ValidationFilter.errorConsumer = errorConsumer;
    }

    public boolean isValidateOnFocusLost() {
        return this.validateOnFocusLost;
    }

    public void setValidateOnFocusLost(boolean validateOnFocusLost) {
        this.validateOnFocusLost = validateOnFocusLost;
    }

    public String getText() {
        return this.textField.getText();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        Objects.requireNonNull(validator, "validator must not be null.");
        this.validator = validator;
    }

    public JTextComponent getTextField() {
        return this.textField;
    }

    public boolean validate(ValidationBehavior behavior) {
        ValidatorException e = this.doValidation();
        if (e == null) {
            this.resetVisualHints();
            return true;
        }
        this.doErrorHandling(e, behavior);
        return false;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (this.updating) {
            super.insertString(fb, offset, string, attr);
            this.updating = false;
        } else {
            String textToInsert = this.doInputValidation(fb, offset, 0, string);
            if (textToInsert != null) {
                fb.insertString(offset, textToInsert, attr);
            }
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.updating) {
            super.replace(fb, offset, length, text, attrs);
            this.updating = false;
        } else {
            String textToInsert = this.doInputValidation(fb, offset, length, text);
            if (textToInsert != null) {
                fb.replace(offset, length, textToInsert, attrs);
            }
        }
    }

    private void setListeners() {
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                String newText = ValidationFilter.this.validator.formatText(ValidationFilter.this.textField.getText(), TextFormat.EDIT);
                if (!newText.equals(ValidationFilter.this.textField.getText())) {
                    ValidationFilter.this.updating = true;
                    ValidationFilter.this.textField.setText(newText);
                }
                ValidationFilter.this.textField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                String newText;
                if (ValidationFilter.this.validateOnFocusLost) {
                    ValidationFilter.this.validate(ValidationBehavior.SET_VISUAL_HINTS);
                }
                if (!(newText = ValidationFilter.this.validator.formatText(ValidationFilter.this.textField.getText(), TextFormat.DISPLAY)).equals(ValidationFilter.this.textField.getText())) {
                    ValidationFilter.this.updating = true;
                    ValidationFilter.this.textField.setText(newText);
                }
            }
        });
    }

    private String doInputValidation(DocumentFilter.FilterBypass fb, int offset, int length, String text) throws BadLocationException {
        StringBuilder textToValidate = this.getCompleteText(fb, offset, length, text);
        int fullTextLength = textToValidate.length();
        int orgTextLength = this.textField.getDocument().getLength();
        boolean appending = this.isAppending(orgTextLength, length, offset);
        if (this.validator.isValidInput(textToValidate, appending)) {
            return appending ? textToValidate.substring(offset) : textToValidate.substring(offset, offset + text.length());
        }
        return null;
    }

    private StringBuilder getCompleteText(DocumentFilter.FilterBypass fb, int offset, int length, String text) throws BadLocationException {
        int textLength = this.textField.getDocument().getLength();
        StringBuilder completeText = new StringBuilder(fb.getDocument().getText(0, textLength));
        completeText.replace(offset, offset + length, text);
        return completeText;
    }

    private boolean isAppending(int length, int removeLength, int offset) {
        return offset >= length - removeLength;
    }

    private ValidatorException doValidation() {
        ValidatorExceptionRef ref = new ValidatorExceptionRef();
        if (!this.validator.validate(this.textField.getText(), ref)) {
            return ref.getException();
        }
        return null;
    }

    private void doErrorHandling(ValidatorException e, ValidationBehavior behavior) {
        switch (behavior) {
            case SHOW_MESSAGE_BOX: {
                this.showErrorMessage(e);
                break;
            }
            case SET_VISUAL_HINTS: {
                this.setVisualHints(e);
                break;
            }
            case THROW_EXCEPTION: {
                throw e;
            }
        }
    }

    private void showErrorMessage(ValidatorException e) {
        if (errorConsumer != null) {
            errorConsumer.accept(e);
        } else {
            this.showError(e);
        }
        this.textField.grabFocus();
        this.textField.selectAll();
    }

    private void showError(ValidatorException e) {
        JOptionPane.showMessageDialog(this.textField.getRootPane(), e.getMessage(), SwingMessages.get("invalidInputHint"), 1);
    }

    private void resetVisualHints() {
        if (!this.hintsVisible) {
            return;
        }
        hintProvider.hideHints(this.textField);
        this.hintsVisible = false;
    }

    private void setVisualHints(ValidatorException e) {
        if (this.hintsVisible) {
            return;
        }
        hintProvider.showHints(this.textField, e);
        this.hintsVisible = true;
    }

    static {
        hintProvider = new BorderValidationHint();
    }
}

