/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.validaton;

import de.ganzer.swing.validaton.ValidationBehavior;
import de.ganzer.swing.validaton.ValidationFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ValidationFilterList
implements Iterable<ValidationFilter> {
    private final List<ValidationFilter> filters = new ArrayList<ValidationFilter>();

    public void addFilter(ValidationFilter filter) {
        Objects.requireNonNull(filter, "filter must not be null.");
        this.filters.add(filter);
    }

    public void removeFilter(ValidationFilter filter) {
        Objects.requireNonNull(filter, "filter must not be null.");
        this.filters.remove(filter);
    }

    public boolean validate(ValidationBehavior behavior) {
        boolean valid = true;
        for (ValidationFilter filter : this) {
            if (filter.validate(behavior)) continue;
            if (behavior == ValidationBehavior.SHOW_MESSAGE_BOX) {
                return false;
            }
            valid = false;
        }
        return valid;
    }

    @Override
    public Iterator<ValidationFilter> iterator() {
        return this.filters.iterator();
    }
}

