/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.download;

import de.ganzer.core.util.Strings;
import de.velocom.veloport.core.download.DownloadException;
import de.velocom.veloport.core.download.Downloader;
import de.velocom.veloport.core.i18n.Messages;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class HTTPSDownloader
implements Downloader {
    private final String srcRoot;

    public HTTPSDownloader(String srcRoot) {
        this.srcRoot = srcRoot;
    }

    @Override
    public boolean checkExistence(String fileName) {
        boolean bl;
        block8: {
            InputStream ignored = new URI(this.srcRoot + "/" + fileName).toURL().openStream();
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    @Override
    public void download(String src, Path dst) throws DownloadException {
        if (Strings.isNullOrBlank(src)) {
            throw new IllegalArgumentException("src must not be null or blank.");
        }
        if (Strings.isNullOrBlank(dst.toString())) {
            throw new IllegalArgumentException("dst must not be null or blank.");
        }
        try {
            Files.createDirectories(dst.getParent(), new FileAttribute[0]);
            try (InputStream in = new URI(this.srcRoot + "/" + src).toURL().openStream();){
                Files.copy(in, dst, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new DownloadException(Messages.get("error.downloadingFile", e.getLocalizedMessage()), e);
        }
    }
}

