/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core;

import java.util.Objects;

public class GMath {
    public static double round(double value, int digits) {
        double fac = Math.pow(10.0, digits);
        double res = Math.round(fac * value);
        return res / fac;
    }

    public static float round(float value, int digits) {
        float fac = (float)Math.pow(10.0, digits);
        float res = Math.round(fac * value);
        return res / fac;
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        Objects.requireNonNull(a, " a must not be null.");
        Objects.requireNonNull(b, " b must not be null.");
        return a.compareTo(b) < 0 ? a : b;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        Objects.requireNonNull(a, " a must not be null.");
        Objects.requireNonNull(b, " b must not be null.");
        return a.compareTo(b) > 0 ? a : b;
    }

    public static int toRange(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static long toRange(long value, long min, long max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float toRange(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double toRange(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static <T extends Comparable<T>> T toRange(T value, T min, T max) {
        return GMath.min(GMath.max(value, min), max);
    }

    public static boolean isInRange(int value, int min, int max) {
        return min <= value && value <= max;
    }

    public static boolean isInRange(long value, long min, long max) {
        return min <= value && value <= max;
    }

    public static boolean isInRange(float value, float min, float max) {
        return min <= value && value <= max;
    }

    public static boolean isInRange(double value, double min, double max) {
        return min <= value && value <= max;
    }

    public static <T extends Comparable<T>> boolean isInRange(T value, T min, T max) {
        Objects.requireNonNull(value, "value must not be null.");
        Objects.requireNonNull(min, "min must not be null.");
        Objects.requireNonNull(max, "max must not be null.");
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }
}

