/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.files;

import de.ganzer.core.files.CopyErrorAction;
import de.ganzer.core.files.CopyProgressContinuation;
import de.ganzer.core.files.CopyProgressStatus;
import de.ganzer.core.files.FileError;
import de.ganzer.core.files.FileErrorProvider;
import de.ganzer.core.files.OverwriteAction;
import de.ganzer.core.internals.CoreMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FileCopy
extends FileErrorProvider {
    private final ProgressFunction progressFunction;
    private final QueryErrorAction queryErrorAction;
    private final QueryOverwriteAction queryOverwriteAction;
    private final AlternativeTargetPathFunction alternativeTargetPathFunction;
    private final ProgressInfo progress = new ProgressInfo(this);
    private OverwriteAction defaultFileOverwriteAction = OverwriteAction.NOT;
    private OverwriteAction defaultDirOverwriteAction = OverwriteAction.NOT;
    private byte[] copyBuffer = new byte[8192];
    private FilenameFilter filenameFilter;

    public FileCopy(ProgressFunction progressFunction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = null;
        this.queryOverwriteAction = null;
        this.alternativeTargetPathFunction = null;
    }

    public FileCopy(ProgressFunction progressFunction, QueryOverwriteAction queryOverwriteAction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = null;
        this.queryOverwriteAction = queryOverwriteAction;
        this.alternativeTargetPathFunction = null;
    }

    public FileCopy(ProgressFunction progressFunction, QueryErrorAction queryErrorAction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = queryErrorAction;
        this.queryOverwriteAction = null;
        this.alternativeTargetPathFunction = null;
    }

    public FileCopy(ProgressFunction progressFunction, QueryErrorAction queryErrorAction, QueryOverwriteAction queryOverwriteAction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = queryErrorAction;
        this.queryOverwriteAction = queryOverwriteAction;
        this.alternativeTargetPathFunction = null;
    }

    public FileCopy(ProgressFunction progressFunction, QueryErrorAction queryErrorAction, QueryOverwriteAction queryOverwriteAction, AlternativeTargetPathFunction alternativeTargetPathFunction) {
        this.progressFunction = progressFunction;
        this.queryErrorAction = queryErrorAction;
        this.queryOverwriteAction = queryOverwriteAction;
        this.alternativeTargetPathFunction = alternativeTargetPathFunction;
    }

    public OverwriteAction getDefaultFileOverwriteAction() {
        return this.defaultFileOverwriteAction;
    }

    public void setDefaultFileOverwriteAction(OverwriteAction defaultFileOverwriteAction) {
        Objects.requireNonNull(defaultFileOverwriteAction, "defaultFileOverwriteAction");
        this.defaultFileOverwriteAction = defaultFileOverwriteAction;
    }

    public OverwriteAction getDefaultDirOverwriteAction() {
        return this.defaultDirOverwriteAction;
    }

    public void setDefaultDirOverwriteAction(OverwriteAction defaultDirOverwriteAction) {
        Objects.requireNonNull(defaultDirOverwriteAction, "defaultDirOverwriteAction");
        this.defaultDirOverwriteAction = defaultDirOverwriteAction;
    }

    public int getCopyBufferSize() {
        return this.copyBuffer.length;
    }

    public void setCopyBufferSize(int copyBufferSize) {
        this.copyBuffer = new byte[copyBufferSize];
    }

    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public boolean start(String source, String target, boolean suppressInit) {
        return this.start(Collections.singletonList(source), target, suppressInit);
    }

    public boolean start(List<String> sources, String target, boolean suppressInit) {
        Objects.requireNonNull(sources, "sources");
        Objects.requireNonNull(target, "target");
        List<File> sourceFiles = sources.stream().map(File::new).collect(Collectors.toList());
        File targetFile = new File(target);
        this.clearError();
        try {
            this.verifyTargetType(targetFile);
            this.verifyExistence(sourceFiles, targetFile);
            this.verifyNonRecursive(sourceFiles, targetFile);
            this.initializeCopy(sourceFiles, targetFile, suppressInit);
            this.copyEntries(sourceFiles, targetFile);
        }
        catch (ErrorInfo info) {
            this.setErrorInfo(info.getError(), info.getErrorDescription());
        }
        this.reportFinished();
        return this.getError() != FileError.NONE;
    }

    private void verifyTargetType(File targetFile) throws ErrorInfo {
        if (targetFile.isFile()) {
            throw new ErrorInfo(FileError.TARGET_TYPE, String.format(CoreMessages.get("invalidCopyTarget"), targetFile.getAbsolutePath()), true);
        }
    }

    private void verifyExistence(List<File> sourceFiles, File targetFile) throws ErrorInfo {
        sourceFiles.forEach(this::verifySourceExistence);
        this.verifyDestExistence(targetFile);
    }

    private void verifySourceExistence(File sourceFile) throws ErrorInfo {
        if (!sourceFile.exists()) {
            throw new ErrorInfo(FileError.SOURCE_NOT_EXIST, String.format(CoreMessages.get("sourceFileDoesNotExist"), sourceFile.getAbsolutePath()), true);
        }
    }

    private void verifyDestExistence(File targetFile) throws ErrorInfo {
        if (!targetFile.exists() && !targetFile.mkdirs()) {
            throw new ErrorInfo(FileError.CREATE_DIR, String.format(CoreMessages.get("cannotCreateDir"), targetFile.getAbsolutePath()), true);
        }
    }

    private void verifyNonRecursive(List<File> sourceFiles, File targetFile) throws ErrorInfo {
        sourceFiles.forEach(file -> this.verifyNonRecursive((File)file, targetFile));
    }

    private void verifyNonRecursive(File sourceFile, File targetFile) throws ErrorInfo {
        Path sourcePath = Path.of(sourceFile.getAbsolutePath(), new String[0]);
        Path targetPath = Path.of(targetFile.getAbsolutePath(), new String[0]);
        if (targetPath.equals(sourcePath) || targetPath.startsWith(sourcePath)) {
            throw new ErrorInfo(FileError.CREATE_DIR, String.format(CoreMessages.get("cannotCopyIntoItself"), sourceFile.getAbsolutePath()), true);
        }
    }

    private void initializeCopy(List<File> sourceFiles, File targetFile, boolean suppressInit) throws ErrorInfo {
        this.progress.status = CopyProgressStatus.INITIALIZING;
        this.progress.rootTargetPath = targetFile.getAbsolutePath();
        this.progress.fileBytesAvail = 0L;
        this.progress.fileBytesCopied = 0L;
        this.progress.totalBytesAvail = 0L;
        this.progress.totalBytesCopied = 0L;
        this.progress.sourcePath = "";
        this.progress.targetPath = "";
        this.progress.dirOverwriteAction = this.defaultDirOverwriteAction;
        this.progress.fileOverwriteAction = this.defaultFileOverwriteAction;
        this.progress.ignoreAllErrors = false;
        this.progress.ignoredErrors.clear();
        if (suppressInit) {
            return;
        }
        this.reportProgress();
        sourceFiles.forEach(source -> {
            this.progress.rootSourcePath = source.getAbsolutePath();
            if (source.isDirectory()) {
                this.initializeCopy((File)source);
            } else {
                this.reportInitializeProgress(this.progress.rootSourcePath, source.length());
            }
        });
    }

    private boolean reportProgress() {
        if (this.progressFunction == null) {
            return true;
        }
        CopyProgressContinuation result = this.progressFunction.report(this.progress);
        if (result == CopyProgressContinuation.CANCEL) {
            this.cancel();
        }
        return result == CopyProgressContinuation.CONTINUE;
    }

    private boolean reportStartDir(String sourcePath, String targetPath) {
        this.progress.status = CopyProgressStatus.START_DIRECTORY;
        this.progress.sourcePath = sourcePath;
        this.progress.targetPath = targetPath;
        this.progress.fileBytesAvail = 0L;
        this.progress.fileBytesCopied = 0L;
        return this.reportProgress();
    }

    private void reportFinishedDir(String sourcePath, String targetPath) {
        this.progress.status = CopyProgressStatus.FINISHED_DIRECTORY;
        this.progress.sourcePath = sourcePath;
        this.progress.targetPath = targetPath;
        this.progress.fileBytesAvail = 0L;
        this.progress.fileBytesCopied = 0L;
        this.reportProgress();
    }

    private boolean reportStartFile(File source, String targetPath) {
        this.progress.status = CopyProgressStatus.START_FILE;
        this.progress.sourcePath = source.getAbsolutePath();
        this.progress.targetPath = targetPath;
        this.progress.fileBytesAvail = source.length();
        this.progress.fileBytesCopied = 0L;
        return this.reportProgress();
    }

    boolean reportCopyingFile(long addBytesCopied) {
        this.progress.status = CopyProgressStatus.COPYING_FILE;
        this.progress.fileBytesCopied += addBytesCopied;
        this.progress.totalBytesCopied += addBytesCopied;
        return this.reportProgress();
    }

    private void reportFinishedFile() {
        this.progress.status = CopyProgressStatus.FINISHED_FILE;
        this.progress.fileBytesCopied = this.progress.fileBytesAvail;
        this.reportProgress();
    }

    private void reportInitializeProgress(String sourcePath, long addTotalBytes) {
        this.progress.sourcePath = sourcePath;
        this.progress.totalBytesAvail += addTotalBytes;
        this.reportProgress();
    }

    private void reportFinished() {
        this.progress.status = CopyProgressStatus.FINISHED;
        this.progress.fileBytesAvail = 0L;
        this.progress.fileBytesCopied = 0L;
        this.progress.sourcePath = "";
        this.progress.targetPath = "";
        this.reportProgress();
    }

    private boolean exists(File file) throws ErrorInfo {
        try {
            return file.exists();
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), file.getAbsolutePath()), true);
        }
    }

    private boolean isDirectory(File file) throws ErrorInfo {
        try {
            return file.isDirectory();
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), file.getAbsolutePath()), true);
        }
    }

    private File[] listFiles(File source) {
        try {
            return this.filenameFilter == null ? source.listFiles() : source.listFiles(this.filenameFilter);
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), source.getAbsolutePath()), true);
        }
    }

    private void initializeCopy(File source) {
        this.reportInitializeProgress(source.getAbsolutePath(), 0L);
        for (File file : this.listFiles(source)) {
            if (this.isDirectory(file)) {
                this.initializeCopy(file);
                continue;
            }
            this.reportInitializeProgress(file.getAbsolutePath(), file.length());
        }
    }

    private void copyEntries(List<File> sourceFiles, File targetFile) throws ErrorInfo {
        sourceFiles.forEach(source -> {
            File target = new File(this.queryDestPath((File)source, targetFile));
            if (this.exists(target)) {
                this.verifyNonRecursive((File)source, target);
            }
            this.progress.rootSourcePath = source.getAbsolutePath();
            if (this.isDirectory((File)source)) {
                this.copyDir((File)source, target.getAbsolutePath());
            } else {
                this.copyFile((File)source, target.getAbsolutePath());
            }
        });
    }

    private String queryDestPath(File source, File target) {
        Path srcPath = Path.of(source.getAbsolutePath(), new String[0]);
        Path dstPath = Path.of(target.getAbsolutePath(), source.getName());
        if (this.alternativeTargetPathFunction == null) {
            return dstPath.toString();
        }
        if (dstPath.equals(srcPath) && target.exists()) {
            return this.alternativeTargetPathFunction.alternativePath(dstPath.toString());
        }
        return dstPath.toString();
    }

    private void copyDir(File source, String targetPath) {
        if (!this.reportStartDir(source.getAbsolutePath(), targetPath)) {
            return;
        }
        block8: while (true) {
            try {
                if (!this.canWriteDir(source, new File(targetPath))) {
                    return;
                }
                this.copyDirNoQuery(source, targetPath);
            }
            catch (ErrorInfo info) {
                if (this.queryErrorAction == null || info.doNotQuery()) {
                    throw info;
                }
                if (this.progress.ignoreAllErrors || this.progress.ignoredErrors.contains((Object)info.getError())) {
                    return;
                }
                switch (this.queryErrorAction.query(info.getError(), info.getErrorDescription(), source, new File(targetPath))) {
                    case RETRY: {
                        continue block8;
                    }
                    case IGNORE: {
                        return;
                    }
                    case IGNORE_ALL_THIS: {
                        this.progress.ignoredErrors.add(info.getError());
                        return;
                    }
                    case IGNORE_ALL: {
                        this.progress.ignoreAllErrors = true;
                        return;
                    }
                }
                throw new ErrorInfo(info.getError(), info.getErrorDescription(), false);
            }
            break;
        }
        this.reportFinishedDir(source.getAbsolutePath(), targetPath);
    }

    private void copyDirNoQuery(File source, String targetPath) {
        for (File file : this.listFiles(source)) {
            String newTargetPath = Path.of(targetPath, file.getName()).toString();
            if (this.isDirectory(file)) {
                this.copyDir(file, newTargetPath);
                continue;
            }
            this.copyFile(file, newTargetPath);
        }
        this.copyAttributes(source, new File(targetPath));
    }

    private void copyFile(File source, String targetPath) {
        if (!this.reportStartFile(source, targetPath)) {
            return;
        }
        block8: while (true) {
            try {
                if (!this.canWriteFile(source, new File(targetPath))) {
                    return;
                }
                this.copyFileNoQuery(source, targetPath);
            }
            catch (ErrorInfo info) {
                if (this.queryErrorAction == null || info.doNotQuery()) {
                    throw info;
                }
                if (this.progress.ignoreAllErrors || this.progress.ignoredErrors.contains((Object)info.getError())) {
                    return;
                }
                switch (this.queryErrorAction.query(info.getError(), info.getErrorDescription(), source, new File(targetPath))) {
                    case RETRY: {
                        continue block8;
                    }
                    case IGNORE: {
                        return;
                    }
                    case IGNORE_ALL_THIS: {
                        this.progress.ignoredErrors.add(info.getError());
                        return;
                    }
                    case IGNORE_ALL: {
                        this.progress.ignoreAllErrors = true;
                        return;
                    }
                }
                throw new ErrorInfo(info.getError(), info.getErrorDescription(), false);
            }
            break;
        }
        this.reportFinishedFile();
    }

    private void copyFileNoQuery(File source, String targetPath) {
        File orgTarget;
        File target = orgTarget = new File(targetPath);
        long totalBytesRead = 0L;
        try {
            FileInputStream in;
            FileOutputStream out;
            block10: {
                int bytesRead;
                if (target.exists()) {
                    target = new File(targetPath + "~");
                }
                if (!target.createNewFile()) {
                    throw new ErrorInfo(FileError.CREATE_FILE, String.format(CoreMessages.get("cannotCreateFile"), target.getAbsolutePath()), true);
                }
                out = new FileOutputStream(target);
                in = new FileInputStream(source);
                do {
                    try {
                        bytesRead = in.read(this.copyBuffer);
                    }
                    catch (IOException e) {
                        this.cleanup(target);
                        throw new ErrorInfo(FileError.READ_FILE, String.format(CoreMessages.get("cannotReadFile"), source.getAbsolutePath()), true);
                    }
                    if (bytesRead == -1) break block10;
                    try {
                        out.write(this.copyBuffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        this.cleanup(target);
                        throw new ErrorInfo(FileError.WRITE_FILE, String.format(CoreMessages.get("cannotWriteFile"), target.getAbsolutePath()), true);
                    }
                    totalBytesRead += (long)bytesRead;
                } while (this.reportCopyingFile(bytesRead));
                this.progress.totalBytesCopied -= totalBytesRead;
                this.cleanup(target);
                return;
            }
            in.close();
            out.close();
            this.copyAttributes(source, target);
            this.cleanup(target, orgTarget);
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), target.getAbsolutePath()), true);
        }
        catch (IOException e) {
            this.cleanup(target);
            throw new ErrorInfo(FileError.CREATE_FILE, String.format(CoreMessages.get("cannotCreateFile"), target.getAbsolutePath()), true);
        }
    }

    private void cleanup(File target, File orgTarget) {
        if (orgTarget == target) {
            return;
        }
        this.cleanup(orgTarget);
        try {
            if (!target.renameTo(orgTarget)) {
                this.cleanup(target);
                throw new ErrorInfo(FileError.RENAME_FILE, String.format(CoreMessages.get("cannotRenameFile"), target.getAbsolutePath()), true);
            }
        }
        catch (SecurityException e) {
            this.cleanup(target);
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), target.getAbsolutePath()), true);
        }
    }

    private void cleanup(File target) {
        try {
            if (target.exists() && !target.delete()) {
                throw new ErrorInfo(FileError.DELETE_FILE, String.format(CoreMessages.get("cannotDeleteFile"), target.getAbsolutePath()), true);
            }
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), target.getAbsolutePath()), true);
        }
    }

    private void copyAttributes(File source, File target) {
        if (!target.setLastModified(source.lastModified()) || !target.setExecutable(source.canExecute())) {
            throw new ErrorInfo(FileError.SET_ATTRIBUTES, String.format(CoreMessages.get("cannotSetAttributes"), target.getAbsolutePath()), true);
        }
    }

    private boolean canWriteDir(File source, File target) {
        try {
            if (!target.exists()) {
                if (!target.mkdirs()) {
                    throw new ErrorInfo(FileError.CREATE_DIR, String.format(CoreMessages.get("cannotCreateDir"), target.getAbsolutePath()), true);
                }
                return true;
            }
        }
        catch (SecurityException e) {
            throw new ErrorInfo(FileError.ACCESS, String.format(CoreMessages.get("accessDenied"), target.getAbsolutePath()), true);
        }
        if (this.progress.dirOverwriteAction == OverwriteAction.NONE) {
            return false;
        }
        if (!this.isDirectory(target)) {
            throw new ErrorInfo(FileError.TARGET_SOURCE_TYPE, String.format(CoreMessages.get("cannotOverwriteFileWithDir"), target.getAbsolutePath()), true);
        }
        if (this.progress.dirOverwriteAction == OverwriteAction.ALL) {
            return true;
        }
        if (this.queryOverwriteAction == null) {
            return false;
        }
        this.progress.dirOverwriteAction = this.queryOverwriteAction.query(source, target);
        if (this.progress.dirOverwriteAction == null || this.progress.dirOverwriteAction == OverwriteAction.CANCEL) {
            this.cancel();
        }
        return this.progress.dirOverwriteAction == OverwriteAction.ALL || this.progress.dirOverwriteAction == OverwriteAction.ONE;
    }

    boolean canWriteFile(File source, File target) {
        if (!this.exists(target)) {
            return true;
        }
        if (this.progress.fileOverwriteAction == OverwriteAction.NONE) {
            return false;
        }
        if (this.isDirectory(target)) {
            throw new ErrorInfo(FileError.TARGET_SOURCE_TYPE, String.format(CoreMessages.get("cannotOverwriteDirWithFile"), target.getAbsolutePath()), true);
        }
        if (this.progress.fileOverwriteAction == OverwriteAction.ALL) {
            return true;
        }
        if (this.queryOverwriteAction == null) {
            return false;
        }
        this.progress.fileOverwriteAction = this.queryOverwriteAction.query(source, target);
        if (this.progress.dirOverwriteAction == null || this.progress.fileOverwriteAction == OverwriteAction.CANCEL) {
            this.cancel();
        }
        return this.progress.fileOverwriteAction == OverwriteAction.ALL || this.progress.fileOverwriteAction == OverwriteAction.ONE;
    }

    private void cancel() throws ErrorInfo {
        throw new ErrorInfo(FileError.CANCELED, CoreMessages.get("operationCanceled"), false);
    }

    public static class ProgressInfo {
        private final FileCopy machine;
        private CopyProgressStatus status;
        private String sourcePath;
        private String targetPath;
        private String rootSourcePath;
        private String rootTargetPath;
        private long fileBytesAvail;
        private long fileBytesCopied;
        private long totalBytesAvail;
        private long totalBytesCopied;
        private OverwriteAction fileOverwriteAction;
        private OverwriteAction dirOverwriteAction;
        private boolean ignoreAllErrors;
        private final Set<FileError> ignoredErrors = new HashSet<FileError>();

        private ProgressInfo(FileCopy machine) {
            this.machine = machine;
        }

        public FileCopy getMachine() {
            return this.machine;
        }

        public CopyProgressStatus getStatus() {
            return this.status;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public String getRootSourcePath() {
            return this.rootSourcePath;
        }

        public String getRootTargetPath() {
            return this.rootTargetPath;
        }

        public long getFileBytesAvail() {
            return this.fileBytesAvail;
        }

        public long getFileBytesCopied() {
            return this.fileBytesCopied;
        }

        public long getTotalBytesAvail() {
            return this.totalBytesAvail;
        }

        public long getTotalBytesCopied() {
            return this.totalBytesCopied;
        }

        public double getFilePercentage() {
            return (double)this.fileBytesCopied * 100.0 / (double)this.fileBytesAvail;
        }

        public double getTotalPercentage() {
            return (double)this.totalBytesCopied * 100.0 / (double)this.totalBytesAvail;
        }
    }

    public static interface ProgressFunction {
        public CopyProgressContinuation report(ProgressInfo var1);
    }

    public static interface QueryErrorAction {
        public CopyErrorAction query(FileError var1, String var2, File var3, File var4);
    }

    public static interface QueryOverwriteAction {
        public OverwriteAction query(File var1, File var2);
    }

    public static interface AlternativeTargetPathFunction {
        public String alternativePath(String var1);
    }

    private static class ErrorInfo
    extends RuntimeException {
        private final boolean queryHandling;
        private final FileError error;

        public ErrorInfo(FileError error, String errorDescription, boolean queryHandling) {
            super(errorDescription);
            this.queryHandling = queryHandling;
            this.error = error;
        }

        public boolean doNotQuery() {
            return !this.queryHandling;
        }

        public FileError getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.getMessage();
        }
    }
}

