/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class ExponentialDistribution
implements Distribution<Double> {
    private final double lambda;

    public ExponentialDistribution() {
        this(1.0);
    }

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda");
        }
        this.lambda = lambda;
    }

    @Override
    public Double next(Random random) {
        return -StrictMath.log(1.0 - random.nextDouble()) / this.lambda;
    }
}

