/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.CharCountValidator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;

public class FilterValidator
extends CharCountValidator {
    private String validMask = "";
    private String invalidMask = "";
    private String validChars = "";
    private String invalidChars = "";

    public FilterValidator() {
    }

    public FilterValidator(int options) {
        super(options);
    }

    public FilterValidator(String validMask) {
        this.validMask = validMask == null ? "" : validMask;
        this.validChars = this.generateChars(this.validMask);
    }

    public FilterValidator(int options, String validMask) {
        super(options);
        this.validMask = validMask == null ? "" : validMask;
        this.validChars = this.generateChars(this.validMask);
    }

    public FilterValidator(String validMask, String invalidMask) {
        this.validMask = validMask == null ? "" : validMask;
        this.invalidMask = invalidMask == null ? "" : invalidMask;
        this.validChars = this.generateChars(this.validMask);
        this.invalidChars = this.generateChars(this.invalidMask);
    }

    public FilterValidator(int options, String validMask, String invalidMask) {
        super(options);
        this.validMask = validMask == null ? "" : validMask;
        this.invalidMask = invalidMask == null ? "" : invalidMask;
        this.validChars = this.generateChars(this.validMask);
        this.invalidChars = this.generateChars(this.invalidMask);
    }

    public String getValidMask() {
        return this.validMask;
    }

    public void setValidMask(String validMask) {
        this.validMask = validMask == null ? "" : validMask;
        this.validChars = this.generateChars(this.validMask);
    }

    public String getInvalidMask() {
        return this.invalidMask;
    }

    public void setInvalidMask(String invalidMask) {
        this.invalidMask = invalidMask == null ? "" : invalidMask;
        this.invalidChars = this.generateChars(this.invalidMask);
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        return super.doInputValidation(text, autoFill) && this.validateText(text.toString());
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (this.validateText(text)) {
            return true;
        }
        er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : CoreMessages.get("inputContainsInvalidCharacters")));
        return false;
    }

    private boolean validateText(String text) {
        int i;
        if (text.isEmpty()) {
            return true;
        }
        if (!this.validChars.isEmpty()) {
            for (i = 0; i < text.length(); ++i) {
                if (this.validChars.indexOf(text.charAt(i)) != -1) continue;
                return false;
            }
        }
        if (!this.invalidChars.isEmpty()) {
            for (i = 0; i < text.length(); ++i) {
                if (this.invalidChars.indexOf(text.charAt(i)) == -1) continue;
                return false;
            }
        }
        return true;
    }

    private String generateChars(String mask) {
        StringBuilder target = new StringBuilder();
        for (int m = 0; m < mask.length(); ++m) {
            if (mask.charAt(m) == '-' && m > 0 && m + 1 < mask.length() && mask.charAt(m - 1) < mask.charAt(m + 1)) {
                for (int c = mask.charAt(++m - 2) + '\u0001'; c < mask.charAt(m); ++c) {
                    target.append((char)c);
                }
            }
            target.append(mask.charAt(m));
        }
        return target.toString();
    }
}

