/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.TextFormat;
import de.ganzer.core.validation.Validator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.format.DecimalStyle;

public class NumberValidator
extends Validator {
    private double minValue = -9.223372036854776E18;
    private double maxValue = 9.223372036854776E18;
    private int numDecimals = 0;
    private String displayFormat;
    private String editFormat;

    public NumberValidator() {
    }

    public NumberValidator(int options) {
        super(options);
    }

    public NumberValidator(double minValue, double maxValue) {
        this(1, minValue, maxValue, 0);
    }

    public NumberValidator(int options, double minValue, double maxValue) {
        this(options, minValue, maxValue, 0);
    }

    public NumberValidator(double minValue, double maxValue, int numDecimals) {
        this(1, minValue, maxValue, numDecimals);
    }

    public NumberValidator(int options, double minValue, double maxValue, int numDecimals) {
        super(options);
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue/maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numDecimals = numDecimals;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        if (minValue > this.maxValue) {
            this.maxValue = minValue;
        }
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        if (this.minValue > maxValue) {
            this.minValue = maxValue;
        }
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public void setNumDecimals(int numDecimals) {
        if (numDecimals < 0) {
            throw new IllegalArgumentException("numDecimals");
        }
        this.numDecimals = numDecimals;
    }

    public void setRange(double minValue, double maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setRange(double minValue, double maxValue, int numDecimals) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numDecimals = numDecimals;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat != null && displayFormat.isEmpty() ? null : displayFormat;
    }

    public String getEditFormat() {
        return this.editFormat;
    }

    public void setEditFormat(String editFormat) {
        this.editFormat = editFormat != null && editFormat.isEmpty() ? null : editFormat;
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        if (!super.doInputValidation(text, autoFill)) {
            return false;
        }
        if (text.isEmpty()) {
            return true;
        }
        String t = text.toString();
        DecimalStyle d = DecimalStyle.ofDefaultLocale();
        if (this.numDecimals == 0 && t.indexOf(d.getDecimalSeparator()) != -1) {
            return false;
        }
        if (t.length() == 1 && t.charAt(0) == d.getNegativeSign()) {
            return this.minValue < 0.0;
        }
        try {
            NumberFormat.getInstance().parse(t).doubleValue();
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (text.isEmpty()) {
            return true;
        }
        DecimalStyle d = DecimalStyle.ofDefaultLocale();
        if (this.numDecimals == 0 && text.indexOf(d.getDecimalSeparator()) != -1) {
            er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : CoreMessages.get("inputIsNotInteger")));
            return false;
        }
        try {
            double v = NumberFormat.getInstance().parse(text).doubleValue();
            if (this.minValue <= v && v <= this.maxValue) {
                return true;
            }
            if (this.getErrorMessage() != null) {
                er.setException(new ValidatorException(this.getErrorMessage()));
            } else {
                String mask1 = String.format("%%1$,.%df", this.numDecimals);
                String mask2 = String.format("%%2$,.%df", this.numDecimals);
                String format = String.format(CoreMessages.get("inputOutOfRange"), mask1, mask2);
                er.setException(new ValidatorException(String.format(format, this.minValue, this.maxValue)));
            }
            return false;
        }
        catch (ParseException e) {
            er.setException(new ValidatorException(this.getErrorMessage() != null ? this.getErrorMessage() : CoreMessages.get("inputIsNotNumber")));
            return false;
        }
    }

    @Override
    protected String doFormatText(String text, TextFormat how) {
        try {
            String eFormat;
            double value = NumberFormat.getInstance().parse(text).doubleValue();
            String string = this.editFormat == null ? (this.numDecimals > 0 && value != (double)((int)value) ? String.format("%%.%df", this.numDecimals) : "%.0f") : (eFormat = this.editFormat);
            String dFormat = this.displayFormat == null ? (this.numDecimals > 0 ? String.format("%%,.%df", this.numDecimals) : "%,.0f") : this.displayFormat;
            return String.format(how == TextFormat.DISPLAY ? dFormat : eFormat, value);
        }
        catch (ParseException e) {
            return text;
        }
    }
}

