/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.gui;

import de.velocom.veloport.core.Settings;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.logging.LogTarget;
import de.velocom.veloport.core.logging.Logger;
import de.velocom.veloport.core.util.AppIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LogUI
extends JFrame {
    public static final String CLOSE_ACTION = "LogUI.close";
    private final AtomicBoolean isInClosing = new AtomicBoolean(false);
    private final boolean skipSettings;
    private final PaneLogTarget logTarget;
    private JTextPane logTextPane;
    private JButton copyButton;
    private JButton closeButton;

    public LogUI(int logLevel, String title, boolean skipSettings) {
        super(title);
        this.skipSettings = skipSettings;
        this.setDefaultCloseOperation(3);
        this.initUI();
        this.setSize(800, 600);
        this.setIconImages(AppIcons.getApplicationIcons(AppIcons.Type.LOGGING));
        if (skipSettings) {
            this.setLocationRelativeTo(null);
        } else {
            Settings.ui.apply("LogUI", (JFrame)this);
        }
        this.logTarget = new PaneLogTarget(logLevel, this.logTextPane);
        Logger.addTarget(this.logTarget);
    }

    public void setCloseButtonText(String closeButtonText) {
        this.closeButton.setText(closeButtonText);
    }

    public boolean isCloseEnabled() {
        return this.closeButton.isEnabled();
    }

    public void setCloseEnabled(boolean enable) {
        this.closeButton.setEnabled(enable);
    }

    public void close() {
        if (!this.isCloseEnabled()) {
            return;
        }
        this.isInClosing.set(true);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void addActionListener(ActionListener l) {
        this.closeButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.closeButton.removeActionListener(l);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (!this.isInClosing.get()) {
                SwingUtilities.invokeLater(() -> this.closeButton.doClick());
                return;
            }
            Logger.removeTarget(this.logTarget);
            if (!this.skipSettings) {
                Settings.ui.write("LogUI", (JFrame)this);
                Settings.save();
            }
        }
        super.processWindowEvent(e);
    }

    private void initUI() {
        this.logTextPane = new JTextPane();
        this.logTextPane.setEditable(false);
        this.logTextPane.setContentType("text/html");
        this.logTextPane.addCaretListener(e -> this.copyButton.setEnabled(e.getDot() != e.getMark()));
        String css = "body { font-family: Monospace; font-size: 12pt; }";
        ((HTMLDocument)this.logTextPane.getDocument()).getStyleSheet().addRule(css);
        JScrollPane scrollPane = new JScrollPane(this.logTextPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)this.createButonPanel(), "South");
    }

    private JComponent createButonPanel() {
        JButton scrollToEndButton = new JButton(Messages.get("ui.log.button.scrollToEnd"));
        scrollToEndButton.addActionListener(e -> this.logTextPane.setCaretPosition(this.logTextPane.getDocument().getLength()));
        this.copyButton = new JButton(Messages.get("ui.log.button.copy"));
        this.copyButton.addActionListener(e -> this.logTextPane.copy());
        this.closeButton = new JButton(Messages.get("ui.log.button.close"));
        this.closeButton.setActionCommand(CLOSE_ACTION);
        JPanel panel = new JPanel(null);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.layoutHorizontally(layout, scrollToEndButton, this.copyButton, this.closeButton);
        return panel;
    }

    private void layoutHorizontally(GroupLayout layout, AbstractButton ... buttons) {
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        horizontalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE);
        for (AbstractButton button : buttons) {
            horizontalGroup.addComponent(button);
        }
        horizontalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        for (AbstractButton button : buttons) {
            parallelGroup.addComponent(button);
        }
        verticalGroup.addGroup(parallelGroup);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        layout.linkSize(0, (Component[])buttons);
    }

    private static class PaneLogTarget
    implements LogTarget {
        private final int logLevel;
        private final JTextPane logTextPane;

        public PaneLogTarget(int logLevel, JTextPane logTextPane) {
            this.logLevel = logLevel;
            this.logTextPane = logTextPane;
        }

        @Override
        public void write(int level, String message) {
            if (level > this.logLevel) {
                return;
            }
            message = message.replace("\n", "<br>");
            if (level == 1) {
                message = String.format("<span style='color:red;'>%s</span>", message);
            }
            HTMLEditorKit kit = (HTMLEditorKit)this.logTextPane.getEditorKit();
            HTMLDocument doc = (HTMLDocument)this.logTextPane.getDocument();
            try {
                boolean scrollToEnd = this.logTextPane.getCaretPosition() == this.logTextPane.getDocument().getLength();
                kit.insertHTML(doc, doc.getLength(), message + "<br>", 0, 0, null);
                if (scrollToEnd) {
                    this.logTextPane.setCaretPosition(this.logTextPane.getDocument().getLength());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

