/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.install;

import de.ganzer.core.files.DeleteErrorAction;
import de.ganzer.core.files.FileDelete;
import de.velocom.veloport.core.i18n.Messages;
import de.velocom.veloport.core.install.LauncherInstaller;
import de.velocom.veloport.core.install.LauncherInstallerException;
import de.velocom.veloport.core.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class MacLauncherInstaller
implements LauncherInstaller {
    private final Path jarPath;
    private final Path javaPath;

    public MacLauncherInstaller() {
        this.jarPath = null;
        this.javaPath = null;
    }

    public MacLauncherInstaller(Path jarPath, Path javaPath) {
        this.jarPath = jarPath;
        this.javaPath = javaPath;
    }

    @Override
    public void installLauncher(String launcherName, Path manifestPath, boolean force) throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createAppBundle(false, launcherName, manifestPath);
            this.createAppBundleAlias(launcherName, force);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void installConfigLauncher() throws LauncherInstallerException {
        if (this.jarPath == null || this.javaPath == null) {
            throw new IllegalStateException("This operation cannot be performed in the current state.");
        }
        try {
            this.createAppBundle(true, null, null);
        }
        catch (Exception e) {
            throw new LauncherInstallerException(Messages.get("error.installingLauncher", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeLauncher(String launcherName) throws LauncherInstallerException {
        try {
            Files.deleteIfExists(Path.of(System.getProperty("user.home"), "Desktop", launcherName));
        }
        catch (IOException e) {
            throw new LauncherInstallerException(Messages.get("error.removeLauncher", e.getLocalizedMessage()), e);
        }
        this.removeAppBundle(launcherName);
    }

    @Override
    public void removeConfigLauncher() throws LauncherInstallerException {
        this.removeAppBundle(Messages.get("velo.port.launcher.config"));
    }

    private void removeAppBundle(String launcherName) throws LauncherInstallerException {
        class ErrorInfo {
            LauncherInstallerException ex;

            ErrorInfo(MacLauncherInstaller this$0) {
            }
        }
        ErrorInfo errorInfo = new ErrorInfo(this);
        Path loc = Path.of(System.getProperty("user.home"), "Applications", launcherName + ".app");
        FileDelete delete = new FileDelete(null, (e, d, f) -> {
            errorInfo.ex = new LauncherInstallerException(d, null);
            return DeleteErrorAction.ABORT;
        });
        delete.start(loc.toString(), true);
        if (errorInfo.ex != null) {
            throw errorInfo.ex;
        }
    }

    private void createAppBundle(boolean config, String launcherName, Path manifestPath) throws IOException {
        String name = config ? Messages.get("velo.port.launcher.config") : launcherName;
        String targetDir = Path.of(System.getProperty("user.home"), "Applications", name + ".app").toString();
        Path contentsPath = Path.of(targetDir, "Contents");
        Path macOSPath = Path.of(targetDir, "Contents", "MacOS");
        Path resPath = Path.of(targetDir, "Contents", "Resources");
        Files.createDirectories(macOSPath, new FileAttribute[0]);
        Files.createDirectories(resPath, new FileAttribute[0]);
        MacLauncherInstaller.createMacInfoPList(name, contentsPath.toString(), config);
        this.createMacStartScript(macOSPath.toString(), config, manifestPath);
        this.createMacIcon(resPath.toString(), config);
    }

    private void createMacIcon(String targetDir, boolean config) throws IOException {
        Logger.log(3, Messages.get("log.createIcon"));
        String iconName = config ? "config-icon.icns" : "icon.icns";
        Path iconPath = Path.of(targetDir, iconName);
        String resName = config ? "/de/velocom/veloport/core/icons/vp_config_icon.icns" : "/de/velocom/veloport/core/icons/vp_icon.icns";
        try (InputStream in = this.getClass().getResourceAsStream(resName);){
            if (in == null) {
                throw new IOException("Resource \"" + resName + "\" not found in JAR");
            }
            Files.copy(in, iconPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void createMacInfoPList(String appName, String targetDir, boolean config) throws IOException {
        Logger.log(3, Messages.get("log.createMacInfoPList"));
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n    <dict>\n        <key>CFBundleName</key>\n        <string>%s</string>\n        <key>CFBundleExecutable</key>\n        <string>start</string>\n        <key>CFBundleIconFile</key>\n        <string>%s</string>\n    </dict>\n</plist>\n".formatted(appName, config ? "config-icon" : "icon");
        Path path = Path.of(targetDir, "Info.plist");
        Files.writeString(path, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void createMacStartScript(String targetDir, boolean config, Path manifestPath) throws IOException {
        String manPath = manifestPath != null ? String.format("\"%s\"", manifestPath) : "";
        String content = "#!/bin/bash\n\"%s\" -jar \"%s\" %s \"$@\"\n".formatted(this.javaPath, this.jarPath, config ? "--configure" : manPath);
        Path path = Path.of(targetDir, "start");
        String cmd = "chmod +x \"" + String.valueOf(path) + "\"";
        Files.writeString(path, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
        Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
    }

    private void createAppBundleAlias(String launcherName, boolean force) throws IOException {
        Logger.log(3, Messages.get("log.createMacAlias"));
        Path target = Path.of(System.getProperty("user.home"), "Applications", launcherName + ".app");
        Path desktop = Path.of(System.getProperty("user.home"), "Desktop");
        String cmd = "tell application \"Finder\"\n    set targetFile to POSIX file \"%s\"\n    set desktopFolder to POSIX file \"%s\"\n    set newAlias to make alias file to targetFile at desktopFolder\n    set name of newAlias to \"%s\"\nend tell\n".formatted(target, desktop, launcherName);
        Path aliasPath = Path.of(desktop.toString(), launcherName);
        if (!force && Files.exists(aliasPath, new LinkOption[0])) {
            return;
        }
        Files.deleteIfExists(aliasPath);
        ProcessBuilder pb = new ProcessBuilder("osascript", "-");
        Process process = pb.start();
        try (OutputStream writer = process.getOutputStream();){
            writer.write(cmd.getBytes());
        }
        String errorOutput = new String(process.getErrorStream().readAllBytes());
        if (!errorOutput.isBlank()) {
            Logger.log(1, errorOutput);
        }
        int exit = 0;
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("osascript exit code: " + exit);
    }
}

