/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.logging;

import de.velocom.veloport.core.logging.LogTarget;
import java.util.HashSet;
import java.util.Set;

public final class Logger {
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    private static final Set<LogTarget> targets = new HashSet<LogTarget>();

    public static boolean addTarget(LogTarget target) {
        return targets.add(target);
    }

    public static boolean removeTarget(LogTarget target) {
        return targets.remove(target);
    }

    public static void log(int level, String message) {
        for (LogTarget target : targets) {
            target.write(level, message);
        }
    }

    public static void log(int level, String message, Object ... args) {
        Logger.log(level, String.format(message, args));
    }
}

