/*
 * Decompiled with CFR 0.152.
 */
package de.velocom.veloport.core.util;

import de.velocom.veloport.core.util.InvalidCheckSumException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;

public final class Security {
    public static final String SHA_256 = "SHA-256";

    public static void verifyCheckSum(Path path, String algorithm, String chkSum) throws NoSuchAlgorithmException, IOException, InvalidCheckSumException {
        if (!Security.getCheckSum(path, algorithm).equals(chkSum)) {
            throw new InvalidCheckSumException(path);
        }
    }

    public static String getCheckSum(Path path, String algorithm) throws NoSuchAlgorithmException, IOException {
        return Security.getCheckSum(new FileInputStream(path.toFile()), algorithm);
    }

    public static String getCheckSum(InputStream inputStream, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        try (DigestInputStream dis = new DigestInputStream(inputStream, messageDigest);){
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
        }
        return HexFormat.of().formatHex(messageDigest.digest());
    }
}

