/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.actions;

import de.ganzer.swing.actions.CreateOptions;
import de.ganzer.swing.actions.GActionItemBuilder;
import de.ganzer.swing.controls.GButton;
import de.ganzer.swing.controls.GCheckBoxMenuItem;
import de.ganzer.swing.controls.GMenuItem;
import de.ganzer.swing.controls.GRadioButtonMenuItem;
import de.ganzer.swing.controls.GToggleButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class GAction
extends AbstractAction
implements GActionItemBuilder {
    public static final String VISIBILITY_KEY = "visibility";
    public static final String SHORT_NAME_KEY = "short name";
    public static final String TAG_KEY = "tag";
    private final EventListenerList actionListeners = new EventListenerList();
    private boolean selectable;
    private boolean exclusivelySelectable;
    private Object tag;

    public GAction() {
        this.putValue("SwingSelectedKey", false);
        this.putValue(VISIBILITY_KEY, true);
    }

    public GAction(String name) {
        super(name);
        this.putValue("SwingSelectedKey", false);
        this.putValue(VISIBILITY_KEY, true);
    }

    public GAction(String name, Icon icon) {
        super(name, icon);
        this.putValue("SwingSelectedKey", false);
        this.putValue(VISIBILITY_KEY, true);
    }

    public GAction name(String name) {
        this.putValue("Name", name);
        return this;
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public GAction shortName(String name) {
        this.putValue(SHORT_NAME_KEY, name);
        return this;
    }

    public void setShortName(String name) {
        this.putValue(SHORT_NAME_KEY, name);
    }

    public String getShortName() {
        return (String)this.getValue(SHORT_NAME_KEY);
    }

    public GAction command(String command) {
        this.putValue("ActionCommandKey", command);
        return this;
    }

    public void setCommand(String command) {
        this.putValue("ActionCommandKey", command);
    }

    public String getCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public GAction smallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
        return this;
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public GAction largeIcon(Icon icon) {
        this.putValue("SwingLargeIconKey", icon);
        return this;
    }

    public void setLargeIcon(Icon icon) {
        this.putValue("SwingLargeIconKey", icon);
    }

    public Icon getLargeIcon() {
        return (Icon)this.getValue("SwingLargeIconKey");
    }

    public GAction accelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public GAction mnemonic(Integer keyCode) {
        this.putValue("MnemonicKey", keyCode);
        return this;
    }

    public void setMnemonic(Integer keyCode) {
        this.putValue("MnemonicKey", keyCode);
    }

    public Integer getMnemonic() {
        return (Integer)this.getValue("MnemonicKey");
    }

    public GAction displayedMnemonicIndex(Integer index) {
        this.putValue("SwingDisplayedMnemonicIndexKey", index);
        return this;
    }

    public void setDisplayedMnemonicIndex(Integer index) {
        this.putValue("SwingDisplayedMnemonicIndexKey", index);
    }

    public Integer getDisplayedMnemonicIndex() {
        return (Integer)this.getValue("SwingDisplayedMnemonicIndexKey");
    }

    public GAction shortDescription(String description) {
        this.putValue("ShortDescription", description);
        return this;
    }

    public void setShortDescription(String description) {
        this.putValue("ShortDescription", description);
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public GAction longDescription(String description) {
        this.putValue("LongDescription", description);
        return this;
    }

    public void setLongDescription(String description) {
        this.putValue("LongDescription", description);
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public GAction selectable(boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public GAction exclusivelySelectable(boolean selectable) {
        this.exclusivelySelectable = selectable;
        return this;
    }

    public void setExclusivelySelectable(boolean selectable) {
        this.exclusivelySelectable = selectable;
    }

    public boolean isExclusivelySelectable() {
        return this.exclusivelySelectable;
    }

    public GAction selected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
        return this;
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public boolean isSelected() {
        Boolean value = (Boolean)this.getValue("SwingSelectedKey");
        return value != null && value != false;
    }

    public GAction visible(boolean visible) {
        this.putValue(VISIBILITY_KEY, visible);
        return this;
    }

    public void setVisible(boolean visible) {
        this.putValue(VISIBILITY_KEY, visible);
    }

    public boolean isVisible() {
        Boolean value = (Boolean)this.getValue(VISIBILITY_KEY);
        return value == null || value != false;
    }

    public GAction enabled(boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public GAction tag(Object tag) {
        this.putValue(TAG_KEY, tag);
        return this;
    }

    public void setTag(Object tag) {
        this.putValue(TAG_KEY, tag);
    }

    public Object getTag() {
        return this.getValue(TAG_KEY);
    }

    public GAction onAction(ActionListener listener) {
        this.addActionListener(listener);
        return this;
    }

    public void addActionListener(ActionListener listener) {
        Objects.requireNonNull(listener);
        this.actionListeners.add(ActionListener.class, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListeners.getListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(ActionListener.class, listener);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Objects.requireNonNull(event);
        Object[] listeners = this.actionListeners.getListenerList();
        ActionEvent ae = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (ae == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getCommand();
                }
                ae = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(ae);
        }
    }

    @Override
    public JMenuItem createMenuItem() {
        JMenuItem item = this.exclusivelySelectable ? new GRadioButtonMenuItem(this) : (this.selectable ? new GCheckBoxMenuItem(this) : new GMenuItem(this));
        return item;
    }

    @Override
    public void addMenuItems(JMenu target) {
        Objects.requireNonNull(target);
        target.add(this.createMenuItem());
    }

    @Override
    public void addMenuItems(JPopupMenu target) {
        Objects.requireNonNull(target);
        target.add(this.createMenuItem());
    }

    @Override
    public AbstractButton createButton(int options) {
        boolean hideImage = CreateOptions.isSet(options, 4);
        boolean smallImage = CreateOptions.isSet(options, 32);
        boolean shortName = CreateOptions.isSet(options, 64);
        AbstractButton button = this.exclusivelySelectable || this.selectable ? new GToggleButton(this, hideImage, smallImage, shortName) : new GButton(this, hideImage, smallImage, shortName);
        button.setFocusable(CreateOptions.isSet(options, 1));
        button.setHideActionText(this.shouldHideText(options));
        button.setVerticalTextPosition(this.getVerticalTextPosition(options));
        button.setHorizontalTextPosition(this.getHorizontalTextPosition(options));
        button.setBorderPainted(!CreateOptions.isSet(options, 16));
        return button;
    }

    @Override
    public void addButtons(JToolBar target, int options) {
        Objects.requireNonNull(target);
        target.add(this.createButton(options));
    }

    protected final boolean shouldHideText(int options) {
        if (CreateOptions.isSet(options, 2)) {
            return false;
        }
        return !CreateOptions.isSet(options, 4) && (this.getSmallIcon() != null || this.getLargeIcon() != null);
    }

    protected final int getVerticalTextPosition(int options) {
        return CreateOptions.isSet(options, 8) ? 0 : 3;
    }

    protected final int getHorizontalTextPosition(int options) {
        return CreateOptions.isSet(options, 8) ? 11 : 0;
    }
}

