/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.actions;

import de.ganzer.swing.actions.GAction;
import de.ganzer.swing.actions.GActionItemBuilder;
import de.ganzer.swing.actions.GSelectedActionChangedEvent;
import de.ganzer.swing.actions.GSelectedActionChangedListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public class GToggleActionGroup
implements GActionItemBuilder,
Iterable<GAction> {
    private final EventListenerList selectedActionChangedListeners = new EventListenerList();
    private final List<GAction> actions = new ArrayList<GAction>();
    private GAction selectedAction;
    private boolean forceSelection;
    private boolean inPropertyChangeEvent;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (GToggleActionGroup.this.inPropertyChangeEvent || !event.getPropertyName().equals("SwingSelectedKey")) {
                return;
            }
            try {
                GToggleActionGroup.this.inPropertyChangeEvent = true;
                for (GAction action : GToggleActionGroup.this.actions) {
                    if (action != event.getSource()) {
                        action.selected(false);
                        continue;
                    }
                    if (GToggleActionGroup.this.selectedAction == event.getSource()) continue;
                    GToggleActionGroup.this.selectedAction = (GAction)event.getSource();
                    GToggleActionGroup.this.fireSelectedActionChanged(GToggleActionGroup.this.selectedAction);
                }
                if (GToggleActionGroup.this.hasNoSelection()) {
                    if (GToggleActionGroup.this.forceSelection) {
                        ((GAction)event.getSource()).selected(true);
                    } else {
                        GToggleActionGroup.this.selectedAction = null;
                        GToggleActionGroup.this.fireSelectedActionChanged(null);
                    }
                }
            }
            finally {
                GToggleActionGroup.this.inPropertyChangeEvent = false;
            }
        }
    };

    public GToggleActionGroup() {
        this(true);
    }

    public GToggleActionGroup(boolean forceSelection) {
        this.forceSelection = forceSelection;
    }

    public GToggleActionGroup forceSelection(boolean forceSelection) {
        this.forceSelection = forceSelection;
        return this;
    }

    public boolean isForceSelection() {
        return this.forceSelection;
    }

    public GToggleActionGroup onSelectedActionChanged(GSelectedActionChangedListener listener) {
        this.addSelectedActionChangedListener(listener);
        return this;
    }

    public GToggleActionGroup addAll(GAction ... actions) {
        Objects.requireNonNull(actions);
        for (GAction action : List.of(actions)) {
            Objects.requireNonNull(action, "actions must not contain null values.");
            if (action.isSelected()) {
                this.selectedAction = action;
            }
            action.addPropertyChangeListener(this.propertyChangeListener);
            this.actions.add(action);
        }
        return this;
    }

    public GToggleActionGroup disabled(boolean disabled) {
        for (GAction action : this.actions) {
            action.setEnabled(!disabled);
        }
        return this;
    }

    public boolean isDisabled() {
        return this.actions.stream().noneMatch(AbstractAction::isEnabled);
    }

    public void addSelectedActionChangedListener(GSelectedActionChangedListener listener) {
        Objects.requireNonNull(listener);
        this.selectedActionChangedListeners.add(GSelectedActionChangedListener.class, listener);
    }

    public GSelectedActionChangedListener[] getSelectedActionChangedListeners() {
        return (GSelectedActionChangedListener[])this.selectedActionChangedListeners.getListeners(GSelectedActionChangedListener.class);
    }

    public void removeSelectedActionChangedListener(GSelectedActionChangedListener listener) {
        this.selectedActionChangedListeners.remove(GSelectedActionChangedListener.class, listener);
    }

    @Override
    public void addMenuItems(JMenu target) {
        for (GAction action : this.actions) {
            action.addMenuItems(target);
        }
    }

    @Override
    public void addMenuItems(JPopupMenu target) {
        for (GAction action : this.actions) {
            action.addMenuItems(target);
        }
    }

    @Override
    public void addButtons(JToolBar target, int options) {
        for (GAction action : this.actions) {
            action.addButtons(target, options);
        }
    }

    @Override
    public Iterator<GAction> iterator() {
        return this.actions.iterator();
    }

    private boolean hasNoSelection() {
        for (GAction action : this.actions) {
            if (!action.isSelected()) continue;
            return false;
        }
        return true;
    }

    private void fireSelectedActionChanged(GAction source) {
        Object[] listeners = this.selectedActionChangedListeners.getListenerList();
        GSelectedActionChangedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GSelectedActionChangedListener.class) continue;
            if (e == null) {
                GAction selected = source != null && source.isSelected() ? source : null;
                e = new GSelectedActionChangedEvent(this, selected);
            }
            ((GSelectedActionChangedListener)listeners[i + 1]).selectedActionChanged(e);
        }
    }
}

