/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import de.ganzer.core.util.Strings;
import de.ganzer.swing.controls.TabCloseListener;
import de.ganzer.swing.internals.SwingMessages;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class ClosableTabsPane
extends JTabbedPane {
    private final boolean closable;

    public ClosableTabsPane() {
        this.closable = true;
    }

    public ClosableTabsPane(boolean closable) {
        this.closable = closable;
    }

    public ClosableTabsPane(int tabPlacement) {
        super(tabPlacement);
        this.closable = true;
    }

    public ClosableTabsPane(int tabPlacement, boolean closable) {
        super(tabPlacement);
        this.closable = closable;
    }

    public ClosableTabsPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.closable = true;
    }

    public ClosableTabsPane(int tabPlacement, int tabLayoutPolicy, boolean closable) {
        super(tabPlacement, tabLayoutPolicy);
        this.closable = closable;
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new TabHeaderPanel(this, component, title, icon));
        if (this.getTabCount() == 1) {
            this.fireStateChanged();
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null && tab.isEnabled()) {
            super.setSelectedIndex(index);
        }
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosableAt(int index) {
        Component tab = this.getTabComponentAt(index);
        return tab != null && ((TabHeaderPanel)tab).isClosable();
    }

    public void setClosableAt(int index, boolean closable) {
        if (!this.closable) {
            return;
        }
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            ((TabHeaderPanel)tab).setClosable(closable);
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            ((TabHeaderPanel)tab).setTitle(title);
        }
        super.setTitleAt(index, title);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            ((TabHeaderPanel)tab).setIcon(icon);
        }
        super.setIconAt(index, icon);
    }

    @Override
    public void setDisabledIconAt(int index, Icon disabledIcon) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            ((TabHeaderPanel)tab).setDisabledIcon(disabledIcon);
        }
        super.setDisabledIconAt(index, disabledIcon);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            ((TabHeaderPanel)tab).setToolTipText(toolTipText);
        }
        super.setToolTipTextAt(index, toolTipText);
    }

    @Override
    public void setBackgroundAt(int index, Color background) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            tab.setBackground(background);
        }
        super.setBackgroundAt(index, background);
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            tab.setForeground(foreground);
        }
        super.setForegroundAt(index, foreground);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            tab.setEnabled(enabled);
        }
        super.setEnabledAt(index, enabled);
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        Component tab = this.getTabComponentAt(tabIndex);
        if (tab != null) {
            ((TabHeaderPanel)tab).setDisplayedMnemonicIndex(mnemonicIndex);
        }
        super.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
    }

    @Override
    public void setMnemonicAt(int tabIndex, int mnemonic) {
        Component tab = this.getTabComponentAt(tabIndex);
        if (tab != null) {
            ((TabHeaderPanel)tab).setMnemonic(mnemonic);
        }
        super.setMnemonicAt(tabIndex, mnemonic);
    }

    public Font getFontAt(int index) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            return tab.getFont();
        }
        return null;
    }

    public void setFontAt(int index, Font font) {
        Component tab = this.getTabComponentAt(index);
        if (tab != null) {
            tab.setFont(font);
        }
    }

    public synchronized void addCloseListener(TabCloseListener l) {
        this.listenerList.add(TabCloseListener.class, l);
    }

    public synchronized void removeCloseListener(TabCloseListener l) {
        this.listenerList.remove(TabCloseListener.class, l);
    }

    protected void fireCloseTabEvent(int tabIndex) {
        TabCloseListener[] closeListeners;
        for (TabCloseListener closeListener : closeListeners = (TabCloseListener[])this.getListeners(TabCloseListener.class)) {
            closeListener.closeTabPerformed(tabIndex, this.getComponentAt(tabIndex));
        }
    }

    private static class TabHeaderPanel
    extends JPanel {
        private final ClosableTabsPane pane;
        private final Component component;
        private JLabel titleLabel;
        private JLabel iconLabel;
        private TabButton closeButton;
        private Icon icon;
        private Icon disabledIcon;
        private int mnemonic;
        private int displayedMnemonicIndex = -1;

        public TabHeaderPanel(final ClosableTabsPane pane, final Component component, String title, Icon icon) {
            super(new BorderLayout(5, 0));
            Objects.requireNonNull(pane, "pane must not be null");
            Objects.requireNonNull(component, "component must not be null");
            this.pane = pane;
            this.component = component;
            this.setOpaque(false);
            this.setTitle(title);
            this.setIcon(icon);
            this.setClosable(pane.isClosable());
            this.pane.addChangeListener(e -> this.adjustColors());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.isEnabled()) {
                        pane.setSelectedComponent(component);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (this.isEnabled()) {
                        titleLabel.setForeground(UIManager.getColor("TabbedPane.hoverForeground"));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.isEnabled()) {
                        this.adjustColors();
                    }
                }
            });
        }

        @Override
        public Color getForeground() {
            Color color = super.getForeground();
            return color != null ? color : UIManager.getColor("TabbedPane.foreground");
        }

        @Override
        public void setForeground(Color fg) {
            super.setForeground(fg);
            if (this.pane != null) {
                this.adjustColors();
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.titleLabel != null) {
                this.titleLabel.setFont(font);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.isEnabled() == enabled) {
                return;
            }
            super.setEnabled(enabled);
            this.adjustColors();
            if (this.titleLabel != null) {
                this.titleLabel.setEnabled(enabled);
            }
            if (this.iconLabel != null) {
                if (this.disabledIcon != null) {
                    this.iconLabel.setIcon(enabled ? this.icon : this.disabledIcon);
                } else {
                    this.iconLabel.setEnabled(enabled);
                }
            }
            if (this.closeButton != null) {
                this.closeButton.setVisible(enabled);
            }
        }

        public int getDisplayedMnemonicIndex() {
            return this.displayedMnemonicIndex;
        }

        public void setDisplayedMnemonicIndex(int displayedMnemonicIndex) {
            this.displayedMnemonicIndex = displayedMnemonicIndex;
            if (this.titleLabel != null) {
                this.titleLabel.setDisplayedMnemonicIndex(displayedMnemonicIndex);
            }
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            if (this.titleLabel != null) {
                this.titleLabel.setDisplayedMnemonic(mnemonic);
            }
        }

        public boolean isClosable() {
            return this.closeButton != null;
        }

        public void setClosable(boolean closable) {
            if (this.isClosable() == closable) {
                return;
            }
            if (closable) {
                this.closeButton = new TabButton();
                this.add((Component)this.closeButton, "East");
            } else {
                this.remove(this.closeButton);
                this.closeButton = null;
            }
        }

        public String getTitle() {
            return this.titleLabel != null ? this.titleLabel.getText() : null;
        }

        public void setTitle(String title) {
            if (Strings.isNullOrEmpty((String)title)) {
                if (this.titleLabel != null) {
                    this.remove(this.titleLabel);
                    this.titleLabel = null;
                }
            } else if (this.titleLabel == null) {
                this.titleLabel = new JLabel(title);
                this.titleLabel.setOpaque(false);
                this.titleLabel.setFont(this.pane.getFont());
                if (this.displayedMnemonicIndex >= 0) {
                    this.titleLabel.setDisplayedMnemonicIndex(this.displayedMnemonicIndex);
                }
                if (this.mnemonic != 0) {
                    this.titleLabel.setDisplayedMnemonic(this.mnemonic);
                }
                this.add((Component)this.titleLabel, "Center");
            } else {
                this.titleLabel.setText(title);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            if (icon == null) {
                if (this.iconLabel != null) {
                    this.remove(this.iconLabel);
                    this.iconLabel = null;
                }
            } else if (this.iconLabel == null) {
                this.iconLabel = new JLabel(!this.isEnabled() && this.disabledIcon != null ? this.disabledIcon : icon);
                this.iconLabel.setOpaque(false);
                this.add((Component)this.iconLabel, "West");
            } else {
                this.iconLabel.setIcon(!this.isEnabled() && this.disabledIcon != null ? this.disabledIcon : icon);
            }
        }

        public Icon getDisabledIcon() {
            return this.disabledIcon;
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.disabledIcon = disabledIcon;
            if (this.iconLabel != null) {
                this.iconLabel.setIcon(!this.isEnabled() && disabledIcon != null ? disabledIcon : this.icon);
            }
        }

        private void adjustColors() {
            if (!this.isEnabled()) {
                if (this.titleLabel != null) {
                    this.titleLabel.setForeground(UIManager.getColor("TabbedPane.disabledForeground"));
                }
            } else if (this.pane.getSelectedComponent() == this.component) {
                if (this.titleLabel != null) {
                    this.titleLabel.setForeground(UIManager.getColor("TabbedPane.selectedForeground"));
                }
            } else if (this.titleLabel != null) {
                this.titleLabel.setForeground(this.getForeground());
            }
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            public TabButton() {
                int size = 17;
                this.setPreferredSize(new Dimension(size, size));
                this.setToolTipText(SwingMessages.get("closableTabbedPane.action.close"));
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }

            @Override
            public void updateUI() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = TabHeaderPanel.this.pane.indexOfTabComponent(TabHeaderPanel.this);
                if (i != -1) {
                    TabHeaderPanel.this.pane.fireCloseTabEvent(i);
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                this.setVisible(this.isEnabled());
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.MAGENTA);
                } else if (TabHeaderPanel.this.pane.getSelectedComponent() == TabHeaderPanel.this.component) {
                    g2.setColor(UIManager.getColor("TabbedPane.selectedForeground"));
                } else {
                    g2.setColor(UIManager.getColor("TabbedPane.foreground"));
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
        }
    }
}

