/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class GButton
extends JButton {
    private boolean hideImage;
    private boolean useSmallImage;
    private boolean useShortName;

    public GButton() {
    }

    public GButton(Icon icon) {
        super(icon);
    }

    public GButton(String text) {
        super(text);
    }

    public GButton(Action a, boolean hideImage, boolean useSmallImage, boolean useShortName) {
        super(a);
        this.hideImage = hideImage;
        this.useSmallImage = useSmallImage;
        this.useShortName = useShortName;
        if (a != null) {
            if (hideImage) {
                this.setIcon(null);
            } else if (useSmallImage) {
                this.setIcon((Icon)a.getValue("SmallIcon"));
            }
            if (useShortName) {
                this.configureShortNameFromAction(a);
            }
        }
    }

    public GButton(String text, Icon icon) {
        super(text, icon);
    }

    @Override
    public void setHideActionText(boolean hideActionText) {
        if (hideActionText == this.getHideActionText()) {
            return;
        }
        super.setHideActionText(hideActionText);
        if (this.useShortName) {
            this.configureShortNameFromAction(this.getAction());
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.configureVisibilityFromAction(action);
        if (action != null) {
            if (this.hideImage) {
                this.setIcon(null);
            } else if (this.useSmallImage) {
                this.setIcon((Icon)action.getValue("SmallIcon"));
            }
            if (this.useShortName) {
                this.configureShortNameFromAction(action);
            }
        }
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        if ("visibility".equals(propertyName)) {
            this.configureVisibilityFromAction(action);
        } else if ("short name".equals(propertyName)) {
            this.configureShortNameFromAction(action);
        } else {
            super.actionPropertyChanged(action, propertyName);
            if (this.hideImage) {
                this.setIcon(null);
            } else if (this.useSmallImage) {
                this.setIcon((Icon)action.getValue("SmallIcon"));
            }
        }
    }

    private void configureShortNameFromAction(Action action) {
        if (action == null || this.getHideActionText()) {
            return;
        }
        String shortName = (String)action.getValue("short name");
        if (shortName != null) {
            this.setText(shortName);
        } else {
            this.setText((String)action.getValue("Name"));
        }
    }

    private void configureVisibilityFromAction(Action action) {
        if (action == null) {
            return;
        }
        Boolean visible = (Boolean)action.getValue("visibility");
        this.setVisible(visible == null || visible != false);
    }
}

