/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class GTextField
extends JTextField {
    private final UndoManager undoManager = new UndoManager();

    public GTextField() {
        GTextField.initUndoRedo(this, this.undoManager);
    }

    public GTextField(String text) {
        super(text);
        GTextField.initUndoRedo(this, this.undoManager);
    }

    public GTextField(int columns) {
        super(columns);
        GTextField.initUndoRedo(this, this.undoManager);
    }

    public GTextField(String text, int columns) {
        super(text, columns);
        GTextField.initUndoRedo(this, this.undoManager);
    }

    public GTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        GTextField.initUndoRedo(this, this.undoManager);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    static void initUndoRedo(JTextComponent component, final UndoManager undoManager) {
        component.getDocument().addUndoableEditListener(e -> undoManager.addEdit(e.getEdit()));
        int shortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        component.getInputMap().put(KeyStroke.getKeyStroke(90, shortcutKey), "Undo");
        component.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        component.getInputMap().put(KeyStroke.getKeyStroke(89, shortcutKey), "Redo");
        component.getInputMap().put(KeyStroke.getKeyStroke(90, shortcutKey | 0x40), "Redo");
        component.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
    }
}

