/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import de.ganzer.swing.controls.TabCloseListener;
import de.ganzer.swing.internals.SwingMessages;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

@Deprecated(since="5.2", forRemoval=true)
public class TabbedClosablePane
extends JTabbedPane {
    private boolean closable = true;

    public TabbedClosablePane() {
    }

    public TabbedClosablePane(int tabPlacement) {
        super(tabPlacement);
    }

    public TabbedClosablePane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        if (this.closable == closable) {
            return;
        }
        this.closable = closable;
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((TabHeaderPanel)this.getTabComponentAt(i)).adjustClosable();
        }
    }

    public synchronized void addCloseListener(TabCloseListener l) {
        this.listenerList.add(TabCloseListener.class, l);
    }

    public synchronized void removeCloseListener(TabCloseListener l) {
        this.listenerList.remove(TabCloseListener.class, l);
    }

    public void fireCloseTabEvent(int tabIndex) {
        TabCloseListener[] closeListeners;
        for (TabCloseListener closeListener : closeListeners = (TabCloseListener[])this.getListeners(TabCloseListener.class)) {
            closeListener.closeTabPerformed(tabIndex, this.getComponentAt(tabIndex));
        }
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        ((TabHeaderPanel)this.getTabComponentAt(index)).setIcon(icon);
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        ((TabHeaderPanel)this.getTabComponentAt(index)).setTitle(title);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new TabHeaderPanel(this, component, title, icon));
        if (this.getTabCount() == 1) {
            this.fireStateChanged();
        }
    }

    private static class TabHeaderPanel
    extends JPanel
    implements ChangeListener {
        private final TabbedClosablePane pane;
        private final Component component;
        private final JLabel label;
        private JLabel icon;
        private TabButton button;

        public TabHeaderPanel(final TabbedClosablePane pane, final Component component, String title, Icon icon) {
            super(new FlowLayout(0, 0, 0));
            Objects.requireNonNull(pane, "pane must not be null");
            Objects.requireNonNull(component, "component must not be null");
            this.pane = pane;
            this.component = component;
            this.pane.addChangeListener(this);
            this.setOpaque(false);
            this.setIcon(icon);
            this.label = new JLabel(title);
            this.label.setForeground(UIManager.getColor("TabbedPane.foreground"));
            this.add(this.label);
            this.adjustClosable();
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    pane.setSelectedComponent(component);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    label.setForeground(UIManager.getColor("TabbedPane.hoverForeground"));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    label.setForeground(UIManager.getColor("TabbedPane.foreground"));
                }
            });
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public void setIcon(Icon icon) {
            if (icon != null) {
                if (this.icon != null) {
                    this.icon.setIcon(icon);
                } else {
                    if (this.label != null) {
                        this.remove(this.label);
                    }
                    if (this.button != null) {
                        this.remove(this.button);
                    }
                    this.icon = new JLabel(icon);
                    this.icon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                    this.add(this.icon);
                    if (this.label != null) {
                        this.add(this.label);
                    }
                    if (this.button != null) {
                        this.add(this.button);
                    }
                }
            } else if (this.icon != null) {
                this.remove(this.icon);
                this.icon = null;
            }
        }

        public void adjustClosable() {
            this.adjustLabelBorder();
            if (this.pane.closable) {
                this.button = new TabButton();
                this.add(this.button);
            } else if (this.button != null) {
                this.remove(this.button);
                this.button = null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.pane.getSelectedComponent() == this.component) {
                this.label.setForeground(UIManager.getColor("TabbedPane.selectedForeground"));
            } else {
                this.label.setForeground(UIManager.getColor("TabbedPane.foreground"));
            }
        }

        private void adjustLabelBorder() {
            if (this.pane.closable) {
                this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            } else {
                this.label.setBorder(null);
            }
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            public TabButton() {
                int size = 17;
                this.setPreferredSize(new Dimension(size, size));
                this.setToolTipText(SwingMessages.get("closableTabbedPane.action.close"));
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }

            @Override
            public void updateUI() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = TabHeaderPanel.this.pane.indexOfTabComponent(TabHeaderPanel.this);
                if (i != -1) {
                    TabHeaderPanel.this.pane.fireCloseTabEvent(i);
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.MAGENTA);
                } else if (TabHeaderPanel.this.pane.getSelectedComponent() == TabHeaderPanel.this.component) {
                    g2.setColor(UIManager.getColor("TabbedPane.selectedForeground"));
                } else {
                    g2.setColor(UIManager.getColor("TabbedPane.foreground"));
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
        }
    }
}

