/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.controls;

import de.ganzer.swing.controls.TogglePanelIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@JavaBean(defaultProperty="title", description="A component which provides a collapsable container.")
public class TogglePanel
extends JPanel {
    public static final String COLLAPSED_PROPERTY = "collapsed";
    public static final String TITLE_PROPERTY = "title";
    public static final String ICONS_PROPERTY = "icons";
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String ICON_VISIBLE_PROPERTY = "iconVisible";
    public static final String HORIZONTAL_ALIGNMENT_PROPERTY = "horizontalAlignment";
    public static final String FOCUSABLE_PROPERTY = "focusable";
    public static final String TOOL_TIP_TEXT_PROPERTY = "toolTipText";
    private final TitleButton titleButton;
    private TogglePanelIcons icons;
    private Container contentPane;
    private boolean collapsed;
    private boolean iconVisible = true;

    public TogglePanel() {
        this(null, TogglePanelIcons.getDefaultIcons(), new JPanel());
    }

    public TogglePanel(String title) {
        this(title, TogglePanelIcons.getDefaultIcons(), new JPanel());
    }

    public TogglePanel(TogglePanelIcons icons) {
        this(null, icons, new JPanel());
    }

    public TogglePanel(Container contentPane) {
        this("", TogglePanelIcons.getDefaultIcons(), contentPane);
    }

    public TogglePanel(String title, TogglePanelIcons icons) {
        this(title, icons, new JPanel());
    }

    public TogglePanel(String title, Container contentPane) {
        this(title, TogglePanelIcons.getDefaultIcons(), contentPane);
    }

    public TogglePanel(String title, TogglePanelIcons icons, Container contentPane) {
        super(new BorderLayout());
        Objects.requireNonNull(icons, "icons must not be null.");
        Objects.requireNonNull(contentPane, "contentPane must not be null.");
        this.icons = icons;
        this.contentPane = contentPane;
        this.titleButton = new TitleButton(title, icons.getOpened());
        this.titleButton.addActionListener(e -> this.setCollapsed(!this.isCollapsed()));
        this.add((Component)this.titleButton, "North");
        this.add((Component)this.contentPane, "Center");
    }

    public String getTitle() {
        return this.titleButton.getText();
    }

    @BeanProperty(visualUpdate=true, description="The title of the toggle panel.")
    public void setTitle(String title) {
        if (this.titleButton.getText().equals(title)) {
            return;
        }
        String orgTitle = this.titleButton.getText();
        this.titleButton.setText(title);
        this.firePropertyChange(TITLE_PROPERTY, orgTitle, title);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(Container contentPane) {
        if (this.contentPane == contentPane) {
            return;
        }
        Container orgPane = this.contentPane;
        this.contentPane = contentPane;
        if (!this.isCollapsed()) {
            this.remove(orgPane);
            this.add((Component)this.contentPane, "Center");
        }
        this.firePropertyChange(CONTENT_PANE_PROPERTY, orgPane, contentPane);
    }

    public TogglePanelIcons getIcons() {
        return this.icons;
    }

    public void setIcons(TogglePanelIcons icons) {
        if (this.icons == icons) {
            return;
        }
        TogglePanelIcons orgIcons = this.icons;
        this.icons = icons;
        if (this.iconVisible) {
            this.titleButton.setIcon(this.collapsed ? icons.getClosed() : icons.getOpened());
        }
        this.firePropertyChange(ICONS_PROPERTY, orgIcons, icons);
    }

    public int getHorizontalAlignment() {
        return this.titleButton.getHorizontalAlignment();
    }

    @BeanProperty(visualUpdate=true, enumerationValues={"SwingConstants.LEFT", "SwingConstants.CENTER", "SwingConstants.RIGHT", "SwingConstants.LEADING", "SwingConstants.TRAILING"}, description="The horizontal alignment of the text.")
    public void setHorizontalAlignment(int horizontalAlignment) {
        if (this.titleButton.getHorizontalAlignment() == horizontalAlignment) {
            return;
        }
        int orgAlignment = this.titleButton.getHorizontalAlignment();
        this.titleButton.setHorizontalAlignment(horizontalAlignment);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_PROPERTY, orgAlignment, this.titleButton.getHorizontalAlignment());
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    @BeanProperty(visualUpdate=true, description="The visibility of the icon.")
    public void setIconVisible(boolean iconVisible) {
        if (this.isIconVisible() == iconVisible) {
            return;
        }
        boolean orgIconVisible = this.iconVisible;
        this.iconVisible = iconVisible;
        if (iconVisible) {
            this.titleButton.setIcon(this.collapsed ? this.icons.getClosed() : this.icons.getOpened());
        } else {
            this.titleButton.setIcon(null);
        }
        this.firePropertyChange(ICON_VISIBLE_PROPERTY, orgIconVisible, iconVisible);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    @BeanProperty(visualUpdate=true, description="The collapsed state of the toggle panel.")
    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (collapsed) {
            this.remove(this.contentPane);
        } else {
            this.add((Component)this.contentPane, "Center");
        }
        if (this.iconVisible) {
            this.titleButton.setIcon(collapsed ? this.icons.getClosed() : this.icons.getOpened());
        }
        this.firePropertyChange(COLLAPSED_PROPERTY, !collapsed, collapsed);
        Component root = SwingUtilities.getRoot(this);
        if (root != null) {
            SwingUtilities.updateComponentTreeUI(root);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.titleButton.isFocusable();
    }

    @Override
    @BeanProperty(visualUpdate=true, description="The focusable state of the toggle panel.")
    public void setFocusable(boolean focusable) {
        if (this.titleButton.isFocusable() == focusable) {
            return;
        }
        boolean orgFocusable = this.titleButton.isFocusable();
        this.titleButton.setFocusable(focusable);
        this.firePropertyChange(FOCUSABLE_PROPERTY, orgFocusable, focusable);
    }

    @Override
    public String getToolTipText() {
        return this.titleButton.getToolTipText();
    }

    @Override
    @BeanProperty(visualUpdate=true, description="The tool tip text of the toggle panel.")
    public void setToolTipText(String text) {
        if (this.titleButton.getToolTipText().equals(text)) {
            return;
        }
        String orgToolTipText = this.titleButton.getToolTipText();
        super.setToolTipText(text);
        this.firePropertyChange(TOOL_TIP_TEXT_PROPERTY, orgToolTipText, text);
    }

    @Override
    public Dimension getMaximumSize() {
        if (!this.collapsed) {
            return super.getMaximumSize();
        }
        Dimension size = this.titleButton.getPreferredSize();
        size.width = super.getMaximumSize().width;
        return size;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.getContentPane().setSize(width, this.getContentPane().getHeight());
    }

    private static class TitleButton
    extends JButton {
        private final JLabel iconLabel;

        public TitleButton(String title, ImageIcon icon) {
            super(title);
            this.iconLabel = new JLabel(icon);
            this.add(this.iconLabel);
            this.setHorizontalAlignment(10);
            this.setLayout(new FlowLayout(4, 0, 0));
        }

        public void setIcon(ImageIcon icon) {
            this.iconLabel.setIcon(icon);
            if (icon != null) {
                this.setLayout(new FlowLayout(4, 0, 0));
                this.add(this.iconLabel);
            } else {
                this.remove(this.iconLabel);
                this.setLayout(null);
            }
        }
    }
}

