/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.dialogs;

import de.ganzer.swing.dialogs.EscapableDialog;
import de.ganzer.swing.dialogs.ModifiableDataSupport;
import de.ganzer.swing.internals.SwingMessages;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JOptionPane;

public abstract class AbstractModifiableDialog<Data>
extends EscapableDialog
implements ModifiableDataSupport<Data> {
    private final Data data;
    private Consumer<Data> dataConsumer;
    private boolean dataModified = false;

    protected AbstractModifiableDialog(Data data) {
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Frame owner, Data data) {
        super(owner);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Frame owner, String title, Data data) {
        super(owner, title);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Frame owner, String title, GraphicsConfiguration gc, Data data) {
        super(owner, title, gc);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Dialog owner, Data data) {
        super(owner);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Dialog owner, String title, Data data) {
        super(owner, title);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Dialog owner, String title, GraphicsConfiguration gc, Data data) {
        super(owner, title, gc);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Window owner, Data data) {
        super(owner);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Window owner, Dialog.ModalityType modalityType, Data data) {
        super(owner, modalityType);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Window owner, String title, Data data) {
        super(owner, title);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Window owner, String title, Dialog.ModalityType modalityType, Data data) {
        super(owner, title, modalityType);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    protected AbstractModifiableDialog(Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc, Data data) {
        super(owner, title, modalityType, gc);
        Objects.requireNonNull(data, "data cannot be null.");
        this.data = data;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public boolean applyChangedData() {
        if (!this.validateModifiedData()) {
            this.resetEscaped();
            return false;
        }
        this.updateData(this.getData());
        if (this.dataConsumer != null) {
            this.dataConsumer.accept(this.getData());
        }
        this.setDataModified(false);
        return true;
    }

    @Override
    public void setDataConsumer(Consumer<Data> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    @Override
    public boolean isDataModified() {
        return this.dataModified;
    }

    @Override
    public void setDataModified(boolean modified) {
        this.dataModified = modified;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.isModal()) {
                if (!this.isEscaped() && !this.applyChangedData()) {
                    return;
                }
            } else if (this.isDataModified()) {
                switch (this.queryUserToSave()) {
                    case 0: {
                        if (this.applyChangedData()) break;
                        return;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
        super.processWindowEvent(e);
    }

    protected int queryUserToSave() {
        return JOptionPane.showConfirmDialog(this, SwingMessages.get("modifiableDialog.dataHasChanged"), this.getTitle(), 1);
    }

    protected abstract boolean validateModifiedData();

    protected abstract void updateData(Data var1);
}

