/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.util;

import de.ganzer.core.util.UserSettings;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class UISettings
extends UserSettings {
    private static final String KEY_STATE = ".state";
    private static final String KEY_X = ".x";
    private static final String KEY_Y = ".y";
    private static final String KEY_WIDTH = ".width";
    private static final String KEY_HEIGHT = ".height";

    public UISettings(String appName, String appVersion) {
        super(appName, appVersion, "ui");
    }

    public UISettings(String appName, String appVersion, boolean asXml) {
        super(appName, appVersion, "ui", asXml);
    }

    public UISettings(String appName, String appVersion, String fileName) {
        super(appName, appVersion, fileName);
    }

    public UISettings(String appName, String appVersion, String fileName, boolean asXml) {
        super(appName, appVersion, fileName, asXml);
    }

    public void write(String key, JFrame frame) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(frame, "frame must not be null");
        int state = frame.getExtendedState();
        this.write(key + KEY_STATE, state);
        this.writeWindowSettings(key, frame, state);
    }

    public void write(String key, JDialog dialog) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(dialog, "dialog must not be null");
        this.writeWindowSettings(key, dialog, 0);
    }

    public void apply(String key, JFrame frame) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(frame, "frame must not be null");
        this.applyWindowSettings(key, frame);
        int state = this.read(key + KEY_STATE, 0);
        frame.setExtendedState(state & 0xFFFFFFFE);
    }

    public void apply(String key, JDialog dialog) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(dialog, "dialog must not be null");
        this.applyWindowSettings(key, dialog);
    }

    private void writeWindowSettings(String key, Window window, int state) {
        if (UISettings.isNotStateSet(state, 2)) {
            this.write(key + KEY_X, window.getX());
            this.write(key + KEY_WIDTH, window.getWidth());
        }
        if (UISettings.isNotStateSet(state, 4)) {
            this.write(key + KEY_Y, window.getY());
            this.write(key + KEY_HEIGHT, window.getHeight());
        }
    }

    private void applyWindowSettings(String key, Window window) {
        int x = this.read(key + KEY_X, window.getX());
        int y = this.read(key + KEY_Y, window.getY());
        int width = this.read(key + KEY_WIDTH, window.getWidth());
        int height = this.read(key + KEY_HEIGHT, window.getHeight());
        window.setBounds(x, y, width, height);
        UISettings.clamp(UISettings.getDisplays(), window);
    }

    private static void clamp(List<Rectangle> displays, Window window) {
        if (displays.size() == 1) {
            UISettings.clampToPrime(window);
        } else {
            Rectangle bounds = window.getBounds();
            for (Rectangle r2 : displays) {
                if (!r2.contains(bounds)) continue;
                return;
            }
            List<Rectangle> intersections = displays.stream().filter(r -> !bounds.intersection((Rectangle)r).isEmpty()).toList();
            if (intersections.size() == 1) {
                UISettings.clampTo(intersections.get(0), window);
                return;
            }
            for (Rectangle r3 : intersections) {
                if (!r3.contains(bounds.getLocation())) continue;
                return;
            }
            UISettings.clampToPrime(window);
        }
    }

    private static void clampToPrime(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int desktopWidth = (int)screenSize.getWidth();
        int desktopHeight = (int)screenSize.getHeight();
        Rectangle bounds = new Rectangle(0, 0, desktopWidth, desktopHeight);
        UISettings.clampTo(bounds, window);
    }

    private static void clampTo(Rectangle display, Window window) {
        int x = window.getX();
        int y = window.getY();
        int width = window.getWidth();
        int height = window.getHeight();
        if (x + width > display.x + display.width) {
            x -= x + width - (display.x + display.width);
        }
        if (y + height > display.y + display.height) {
            y -= y + height - (display.y + display.height);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setBounds(x, y, width, height);
    }

    private static boolean isNotStateSet(int states, int state) {
        return (states & state) != state;
    }

    private static List<Rectangle> getDisplays() {
        return Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(GraphicsDevice::getDefaultConfiguration).map(config -> {
            DisplayMode dm = config.getDevice().getDisplayMode();
            Rectangle bounds = config.getBounds();
            return new Rectangle((int)bounds.getX(), (int)bounds.getY(), dm.getWidth(), dm.getHeight());
        }).sorted(Comparator.comparing(Rectangle::getX)).toList();
    }
}

