/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.swing.validaton;

import de.ganzer.core.validation.ValidatorException;
import de.ganzer.swing.validaton.ValidationHintProvider;
import java.awt.Color;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class BorderValidationHint
implements ValidationHintProvider {
    private final Border errorBorder;
    private final boolean keepToolTip;
    private String orgTooltip;
    private Border orgBorder;

    public BorderValidationHint() {
        this(BorderFactory.createLineBorder(Color.RED, 1), false);
    }

    public BorderValidationHint(Border errorBorder) {
        this(errorBorder, false);
    }

    public BorderValidationHint(boolean keepToolTip) {
        this(BorderFactory.createLineBorder(Color.RED, 1), keepToolTip);
    }

    public BorderValidationHint(Border errorBorder, boolean keepToolTip) {
        Objects.requireNonNull(errorBorder, "errorBorder must not be null.");
        this.errorBorder = errorBorder;
        this.keepToolTip = keepToolTip;
    }

    public Border getErrorBorder() {
        return this.errorBorder;
    }

    public boolean shouldKeepToolTip() {
        return this.keepToolTip;
    }

    @Override
    public void showHints(JTextComponent target, ValidatorException e) {
        if (!this.shouldKeepToolTip()) {
            this.orgTooltip = target.getToolTipText();
            target.setToolTipText(e.getLocalizedMessage());
        }
        this.orgBorder = target.getBorder();
        target.setBorder(this.errorBorder);
    }

    @Override
    public void hideHints(JTextComponent target) {
        if (!this.shouldKeepToolTip()) {
            target.setToolTipText(this.orgTooltip);
        }
        target.setBorder(this.orgBorder);
        this.orgTooltip = null;
        this.orgBorder = null;
    }
}

