/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core;

public final class OS {
    public static Type getType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return Type.WINDOWS;
        }
        if (osName.contains("linux")) {
            return Type.LINUX;
        }
        if (osName.contains("solaris")) {
            return Type.SOLARIS;
        }
        if (osName.contains("mac")) {
            return Type.MAC;
        }
        return Type.OTHER;
    }

    public static String getName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return OS.getType() == Type.WINDOWS;
    }

    public static boolean isLinux() {
        return OS.getType() == Type.LINUX;
    }

    public static boolean isMac() {
        return OS.getType() == Type.MAC;
    }

    public static boolean isSolaris() {
        return OS.getType() == Type.SOLARIS;
    }

    public static boolean isOther() {
        return OS.getType() == Type.OTHER;
    }

    public static enum Type {
        WINDOWS,
        LINUX,
        MAC,
        SOLARIS,
        OTHER;

    }
}

