/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Objects;

public class CsvOutputStreamWriter
extends OutputStreamWriter {
    private String lineSeparator = System.lineSeparator();
    private char valueSeparator = (char)44;
    private char maskChar = (char)34;

    public CsvOutputStreamWriter(OutputStream out) {
        super(out);
    }

    public CsvOutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        super(out, charsetName);
    }

    public CsvOutputStreamWriter(OutputStream out, Charset cs) {
        super(out, cs);
    }

    public CsvOutputStreamWriter(OutputStream out, CharsetEncoder enc) {
        super(out, enc);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator == null || lineSeparator.isEmpty() ? System.lineSeparator() : lineSeparator;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(char valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public char getMaskChar() {
        return this.maskChar;
    }

    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    public void writeLine(Collection<String> values) throws IOException {
        this.writeLine(values, false);
    }

    public void writeLine(Collection<String> values, boolean maskAlways) throws IOException {
        Objects.requireNonNull(values, "CsvOutputStreamWriter::writeLine: values");
        boolean separate = false;
        for (String value : values) {
            if (separate) {
                this.write(this.valueSeparator);
            } else {
                separate = true;
            }
            this.writeValue(value, maskAlways);
        }
        this.write(this.lineSeparator);
    }

    private void writeValue(String value, boolean maskAlways) throws IOException {
        if (maskAlways || this.shouldMask(value)) {
            this.writeMaskedValue(value);
        } else {
            this.writeUnmaskedValue(value);
        }
    }

    private boolean shouldMask(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!this.requiresMask(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean requiresMask(char c) {
        return c == this.maskChar || c == this.valueSeparator || c == '\n' || c == '\r';
    }

    private void writeMaskedValue(String value) throws IOException {
        this.write(this.maskChar);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == this.maskChar) {
                this.write(this.maskChar);
            }
            this.write(c);
        }
        this.write(this.maskChar);
    }

    private void writeUnmaskedValue(String value) throws IOException {
        this.write(value);
    }
}

