/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class BinomialDistribution
implements Distribution<Long> {
    private final long t;
    private final double p;
    private double pr;
    private double oddsRatio;
    private long r0;

    public BinomialDistribution() {
        this(1L, 0.5);
    }

    public BinomialDistribution(long t) {
        this(t, 0.5);
    }

    public BinomialDistribution(long t, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p");
        }
        this.t = t;
        this.p = p;
        if (0.0 < p && p < 1.0) {
            this.r0 = (long)((double)(t + 1L) * p);
            this.pr = StrictMath.exp(BinomialDistribution.logGamma((double)t + 1.0) - BinomialDistribution.logGamma((double)this.r0 + 1.0) - BinomialDistribution.logGamma((double)(t - this.r0) + 1.0) + (double)this.r0 * StrictMath.log(p) + (double)(t - this.r0) * StrictMath.log(1.0 - p));
            this.oddsRatio = p / (1.0 - p);
        }
    }

    @Override
    public Long next(Random random) {
        long ru;
        double pu;
        if (this.t == 0L || this.p == 0.0) {
            return 0L;
        }
        if (this.p == 1.0) {
            return this.t;
        }
        double u = random.nextDouble() - this.pr;
        if (u < 0.0) {
            return this.r0;
        }
        double pd = pu = this.pr;
        long rd = ru = this.r0;
        do {
            if (rd >= 1L && (u -= (pd *= (double)rd / (this.oddsRatio * (double)(this.t - rd + 1L)))) < 0.0) {
                return rd - 1L;
            }
            --rd;
        } while (++ru > this.t || !((u -= (pu *= (double)(this.t - ru + 1L) * this.oddsRatio / (double)ru)) < 0.0));
        return ru;
    }

    private static double logGamma(double z) {
        double[] coef = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double LogSqrtTwoPi = 0.9189385332046728;
        if (z < 0.5) {
            return StrictMath.log(Math.PI / StrictMath.sin(Math.PI * z)) - BinomialDistribution.logGamma(1.0 - z);
        }
        double zz = z - 1.0;
        double b = zz + 5.5;
        double sum = coef[0];
        for (int i = 1; i < coef.length; ++i) {
            sum += coef[i] / (zz + (double)i);
        }
        return LogSqrtTwoPi + StrictMath.log(sum) - b + StrictMath.log(b) * (zz + 0.5);
    }
}

