/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class ExtremeValueDistribution
implements Distribution<Double> {
    private final double location;
    private final double scale;

    public ExtremeValueDistribution() {
        this(0.0, 1.0);
    }

    public ExtremeValueDistribution(double location) {
        this(location, 1.0);
    }

    public ExtremeValueDistribution(double location, double scale) {
        this.location = location;
        this.scale = scale;
    }

    @Override
    public Double next(Random random) {
        return this.location - this.scale * StrictMath.log(-StrictMath.log(1.0 - random.nextDouble()));
    }
}

