/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import de.ganzer.core.random.GammaDistribution;
import java.util.Random;

public class FisherFDistribution
implements Distribution<Double> {
    private final double m;
    private final double n;
    private final GammaDistribution gammaDistM;
    private final GammaDistribution gammaDistN;

    public FisherFDistribution() {
        this(1.0, 1.0);
    }

    public FisherFDistribution(double m) {
        this(m, 1.0);
    }

    public FisherFDistribution(double m, double n) {
        if (m <= 0.0) {
            throw new IllegalArgumentException("m");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n");
        }
        this.m = m;
        this.n = n;
        this.gammaDistM = new GammaDistribution(m * 0.5);
        this.gammaDistN = new GammaDistribution(n * 0.5);
    }

    @Override
    public Double next(Random random) {
        return this.n * this.gammaDistM.next(random) / (this.m * this.gammaDistN.next(random));
    }
}

