/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import de.ganzer.core.random.ExponentialDistribution;
import java.util.Random;

public class GammaDistribution
implements Distribution<Double> {
    private final double shape;
    private final double scale;
    private final ExponentialDistribution expDist = new ExponentialDistribution();

    public GammaDistribution() {
        this(1.0, 1.0);
    }

    public GammaDistribution(double shape) {
        this(shape, 1.0);
    }

    public GammaDistribution(double shape, double scale) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("shape");
        }
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public Double next(Random random) {
        double x;
        double a = this.shape;
        if (a == 1.0) {
            x = this.expDist.next(random);
        } else if (a > 1.0) {
            double __v;
            double __z;
            double __y;
            double __u;
            double __w;
            double b = a - 1.0;
            double c = 3.0 * a - 0.75;
            do {
                __u = random.nextDouble();
                __v = random.nextDouble();
            } while ((__w = __u * (1.0 - __u)) == 0.0 || !((x = b + (__y = StrictMath.sqrt(c / __w) * (__u - 0.5))) >= 0.0) || !((__z = 64.0 * __w * __w * __w * __v * __v) <= 1.0 - 2.0 * __y * __y / x) && !(StrictMath.log(__z) <= 2.0 * (b * StrictMath.log(x / b) - __y)));
        } else {
            double e;
            double es;
            double u;
            do {
                u = random.nextDouble();
                es = this.expDist.next(random);
            } while (!(u <= 1.0 - a ? (x = StrictMath.pow(u, 1.0 / a)) <= es : (x = StrictMath.pow(1.0 - a + a * (e = -StrictMath.log((1.0 - u) / a)), 1.0 / a)) <= e + es));
        }
        return x * this.scale;
    }
}

