/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.BernoulliDistribution;
import de.ganzer.core.random.Distribution;
import de.ganzer.core.random.GammaDistribution;
import de.ganzer.core.random.PoissonDistribution;
import java.util.Random;

public class NegativeBinomialDistribution
implements Distribution<Long> {
    private final long k;
    private final double p;
    private BernoulliDistribution bernDist;
    private GammaDistribution gammaDist;

    public NegativeBinomialDistribution() {
        this(1L, 0.5);
    }

    public NegativeBinomialDistribution(long k) {
        this(k, 0.5);
    }

    public NegativeBinomialDistribution(long k, double p) {
        if (p > 1.0 || p <= 0.0) {
            throw new IllegalArgumentException("p");
        }
        this.k = k;
        this.p = p;
        if ((double)k <= 21.0 * p) {
            this.bernDist = new BernoulliDistribution(p);
        } else {
            this.gammaDist = new GammaDistribution(k, (1.0 - p) / p);
        }
    }

    @Override
    public Long next(Random random) {
        if ((double)this.k <= 21.0 * this.p) {
            long f = 0L;
            long s = 0L;
            while (s < this.k) {
                if (this.bernDist.next(random)) {
                    ++s;
                    continue;
                }
                ++f;
            }
            return f;
        }
        return new PoissonDistribution(this.gammaDist.next(random)).next(random);
    }
}

