/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import de.ganzer.core.random.ExponentialDistribution;
import de.ganzer.core.random.NormalDistribution;
import java.util.Random;

public class PoissonDistribution
implements Distribution<Long> {
    private final double mean;
    private final double s;
    private final double d;
    private final double l;
    private final double omega;
    private final double c0;
    private final double c1;
    private final double c2;
    private final double c3;
    private final double c;
    private NormalDistribution normDist;
    private ExponentialDistribution expDist;
    private static final long[] fac = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L};

    public PoissonDistribution() {
        this(1.0);
    }

    public PoissonDistribution(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("mean");
        }
        this.mean = mean;
        if (mean < 10.0) {
            this.s = 0.0;
            this.d = 0.0;
            this.l = StrictMath.exp(-mean);
            this.omega = 0.0;
            this.c3 = 0.0;
            this.c2 = 0.0;
            this.c1 = 0.0;
            this.c0 = 0.0;
            this.c = 0.0;
        } else {
            this.normDist = new NormalDistribution();
            this.expDist = new ExponentialDistribution();
            this.s = StrictMath.sqrt(mean);
            this.d = 6.0 * mean * mean;
            this.l = mean - 1.1484;
            this.omega = 0.3989423 / this.s;
            double b1 = 0.04166667 / mean;
            double b2 = 0.3 * b1 * b1;
            this.c3 = 0.1428571 * b1 * b2;
            this.c2 = b2 - 15.0 * this.c3;
            this.c1 = b1 - 6.0 * b2 + 45.0 * this.c3;
            this.c0 = 1.0 - b1 + 3.0 * b2 - 15.0 * this.c3;
            this.c = 0.1069 / mean;
        }
    }

    @Override
    public Long next(Random random) {
        long x = 0L;
        if (this.mean < 10.0) {
            double p = random.nextDouble();
            while (p > this.l) {
                p *= random.nextDouble();
                ++x;
            }
        } else {
            double difmuk = 0.0;
            double u = 0.0;
            double g = this.mean + this.s * this.normDist.next(random);
            if (g > 0.0) {
                x = (long)g;
                if ((double)x >= this.l) {
                    return x;
                }
                difmuk = this.mean - (double)x;
                u = random.nextDouble();
                if (this.d * u >= difmuk * difmuk * difmuk) {
                    return x;
                }
            }
            boolean usingExpDist = false;
            while (true) {
                double py;
                double px;
                double e = 0.0;
                if (usingExpDist || g < 0.0) {
                    double t;
                    do {
                        e = this.expDist.next(random);
                        u = random.nextDouble();
                    } while ((t = 1.8 + ((u += u - 1.0) < 0.0 ? -e : e)) <= -0.6744);
                    x = (long)(this.mean + this.s * t);
                    difmuk = this.mean - (double)x;
                    usingExpDist = true;
                }
                if (x < 10L) {
                    px = -this.mean;
                    py = StrictMath.pow(this.mean, x) / (double)fac[(int)x];
                } else {
                    double del = 0.08333333 / (double)x;
                    del -= 4.8 * del * del * del;
                    double v = difmuk / (double)x;
                    px = StrictMath.abs(v) > 0.25 ? (double)x * StrictMath.log(1.0 + v) - difmuk - del : (double)x * v * v * (((((((0.125006 * v - 0.1384794) * v + 0.1421878) * v - 0.1661269) * v + 0.2000118) * v - 0.2500068) * v + 0.3333333) * v - 0.5) - del;
                    py = 0.3989423 / StrictMath.sqrt(x);
                }
                double r = (0.5 - difmuk) / this.s;
                double r2 = r * r;
                double fx = -0.5 * r2;
                double fy = this.omega * (((this.c3 * r2 + this.c2) * r2 + this.c1) * r2 + this.c0);
                if (usingExpDist ? this.c * StrictMath.abs(u) <= py * StrictMath.exp(px + e) - fy * StrictMath.exp(fx + e) : fy - u * fy <= py * StrictMath.exp(px - fx)) break;
                usingExpDist = true;
            }
        }
        return x;
    }
}

