/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import de.ganzer.core.random.GammaDistribution;
import de.ganzer.core.random.NormalDistribution;
import java.util.Random;

public class StudentTDistribution
implements Distribution<Double> {
    private final double n;
    private final GammaDistribution gammaDist;
    private final NormalDistribution normDist = new NormalDistribution();

    public StudentTDistribution() {
        this(1.0);
    }

    public StudentTDistribution(double n) {
        if (n <= 0.0) {
            throw new IllegalArgumentException("n");
        }
        this.n = n;
        this.gammaDist = new GammaDistribution(n * 0.5, 2.0);
    }

    @Override
    public Double next(Random random) {
        return this.normDist.next(random) * StrictMath.sqrt(this.n / this.gammaDist.next(random));
    }
}

